/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.sql;

import com.actelion.research.chem.StereoMolecule;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayParameter;
import tech.molecules.chem.coredb.AssayQuery;
import tech.molecules.chem.coredb.AssayResult;
import tech.molecules.chem.coredb.AssayResultQuery;
import tech.molecules.chem.coredb.Batch;
import tech.molecules.chem.coredb.Compound;
import tech.molecules.chem.coredb.CoreDB;
import tech.molecules.chem.coredb.CoreDBException;
import tech.molecules.chem.coredb.CoreDBWriter;
import tech.molecules.chem.coredb.DataType;
import tech.molecules.chem.coredb.DataValue;
import tech.molecules.chem.coredb.Project;
import tech.molecules.chem.coredb.ProjectQuery;
import tech.molecules.chem.coredb.Tube;
import tech.molecules.chem.coredb.TubeQuery;
import tech.molecules.chem.coredb.sql.AssayImpl;
import tech.molecules.chem.coredb.sql.AssayParameterImpl;
import tech.molecules.chem.coredb.sql.AssayResultImpl;
import tech.molecules.chem.coredb.sql.BatchImpl;
import tech.molecules.chem.coredb.sql.CompoundImpl;
import tech.molecules.chem.coredb.sql.DBAssay;
import tech.molecules.chem.coredb.sql.DBAssayResult;
import tech.molecules.chem.coredb.sql.DBProject;
import tech.molecules.chem.coredb.sql.ProjectImpl;
import tech.molecules.chem.coredb.sql.SQLHelper;
import tech.molecules.chem.coredb.sql.TubeImpl;

public abstract class DBManager
implements CoreDB,
CoreDBWriter {
    private SQLHelper helper;
    private Connection connection;

    public DBManager(Connection connection, SQLHelper helper) {
        this.connection = connection;
        this.helper = helper;
    }

    @Override
    public List<Assay> fetchAssays(Set<Integer> ids) throws Exception {
        return DBAssay.fetchAssays(this.connection, ids);
    }

    @Override
    public List<AssayResult> searchAssayResults(AssayResultQuery query) throws Exception {
        return DBAssayResult.searchAssayResults(this.connection, query);
    }

    @Override
    public List<Project> fetchProjects(Set<String> projectIds) throws SQLException {
        return DBProject.fetchProjects(this.connection, projectIds);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Project createProject(String id, String name) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(this.helper.getInsertOrIgnoreStatement("project", "id, name", "?, ?"));
        statement.setString(1, id);
        statement.setString(2, name);
        statement.executeUpdate();
        return new ProjectImpl(id, name);
    }

    @Override
    public Assay createAssay(String name, Project project) throws SQLException {
        String query = "INSERT INTO assay (name, project_id) VALUES (?, ?)";
        PreparedStatement statement = this.connection.prepareStatement(query, 1);
        statement.setString(1, name);
        statement.setString(2, project.getId());
        statement.executeUpdate();
        ResultSet resultSet = statement.getGeneratedKeys();
        if (resultSet.next()) {
            int id = resultSet.getInt(1);
            return new AssayImpl(id, name, project, new ArrayList<AssayParameter>());
        }
        throw new SQLException("Failed to create assay");
    }

    @Override
    public AssayParameter createAssayParameter(Assay assay, DataType dataType, String name) throws SQLException {
        String query = "INSERT INTO assay_parameter (assay_id, data_type, name) VALUES (?, ?, ?)";
        PreparedStatement statement = this.connection.prepareStatement(query, 1);
        statement.setInt(1, assay.getId());
        statement.setString(2, dataType.getValue());
        statement.setString(3, name);
        statement.executeUpdate();
        ResultSet resultSet = statement.getGeneratedKeys();
        if (resultSet.next()) {
            int id = resultSet.getInt(1);
            return new AssayParameterImpl(id, assay, dataType, name);
        }
        throw new SQLException("Failed to create assay parameter");
    }

    @Override
    public AssayResult createAssayResult(Assay assay, java.util.Date date, Tube tube) throws SQLException {
        String query = "INSERT INTO assay_result (assay_id, date, tube_id) VALUES (?, ?, ?)";
        PreparedStatement statement = this.connection.prepareStatement(query, 1);
        statement.setInt(1, assay.getId());
        statement.setDate(2, new Date(date.getTime()));
        String tube_id = "<<UNKNOWN>>";
        if (tube != null) {
            tube_id = tube.getId();
        }
        statement.setString(3, tube_id);
        statement.executeUpdate();
        ResultSet resultSet = statement.getGeneratedKeys();
        if (resultSet.next()) {
            long id = resultSet.getLong(1);
            return new AssayResultImpl(id, assay, date, tube, new HashMap<AssayParameter, DataValue>());
        }
        throw new SQLException("Failed to create assay result");
    }

    @Override
    public Compound createCompound(String id, StereoMolecule molecule) throws SQLException, CoreDBException {
        if (molecule == null) {
            throw new CoreDBException("[createCompound] StereoMolecule is null, id = " + id);
        }
        PreparedStatement statement = this.connection.prepareStatement("INSERT INTO compound (id, idcode, idcode_coordinates) VALUES (?,?,?)");
        statement.setString(1, id);
        statement.setString(2, molecule.getIDCode());
        statement.setString(3, molecule.getIDCoordinates());
        statement.executeUpdate();
        return new CompoundImpl(id, molecule);
    }

    @Override
    public Batch createBatch(String id, Compound compound) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("INSERT INTO batch (id, compound_id) VALUES (?, ?)");
        statement.setString(1, id);
        statement.setString(2, compound.getId());
        statement.executeUpdate();
        return new BatchImpl(id, compound.getId());
    }

    @Override
    public Tube createTube(String id, Batch batch) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("INSERT INTO tube (id, batch_id) VALUES (?, ?)");
        statement.setString(1, id);
        statement.setString(2, batch.getId());
        statement.executeUpdate();
        return new TubeImpl(id, batch);
    }

    @Override
    public void addDataValue(AssayResult assayResult, AssayParameter assayParameter, DataValue dataValue) throws SQLException {
        String query = "INSERT INTO assay_result_data (assay_result_id, assay_parameter_id, double_value, text_value) VALUES (?, ?, ?, ?)";
        PreparedStatement statement = this.connection.prepareStatement(query);
        statement.setLong(1, assayResult.getId());
        statement.setInt(2, assayParameter.getId());
        statement.setDouble(3, dataValue.getAsDouble());
        statement.setString(4, dataValue.getAsText());
        int affectedRows = statement.executeUpdate();
        if (affectedRows == 0) {
            throw new SQLException("Failed to add data value");
        }
    }

    @Override
    public List<Tube> searchTubes(TubeQuery query) throws SQLException {
        ArrayList<Tube> result = new ArrayList<Tube>();
        StringBuilder sb = new StringBuilder("SELECT tube.id as tube_id, tube.batch_id, batch.compound_id, compound.idcode ").append("FROM tube ").append("JOIN batch ON tube.batch_id = batch.id ").append("WHERE 1=1");
        if (query.getBatchId() != null) {
            sb.append(" AND tube.batch_id = ?");
        }
        PreparedStatement statement = this.connection.prepareStatement(sb.toString());
        int parameterIndex = 1;
        if (query.getBatchId() != null) {
            statement.setString(parameterIndex, query.getBatchId());
        }
        ResultSet resultSet = statement.executeQuery();
        while (resultSet.next()) {
            String tubeId = resultSet.getString("tube_id");
            String batchId = resultSet.getString("batch_id");
            String compoundId = resultSet.getString("compound_id");
            BatchImpl batch = new BatchImpl(batchId, compoundId);
            result.add(new TubeImpl(tubeId, batch));
        }
        return result;
    }

    @Override
    public List<Tube> fetchTubes(List<String> tubeIds) {
        ArrayList<Tube> tubes = new ArrayList<Tube>();
        try {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("SELECT t.id AS tube_id, t.batch_id, b.id AS batch_id, b.compound_id ");
            queryBuilder.append("FROM tube t ");
            queryBuilder.append("JOIN batch b ON t.batch_id = b.id ");
            queryBuilder.append("WHERE t.id IN (");
            for (int i = 0; i < tubeIds.size(); ++i) {
                queryBuilder.append("?");
                if (i >= tubeIds.size() - 1) continue;
                queryBuilder.append(", ");
            }
            queryBuilder.append(")");
            String query = queryBuilder.toString();
            PreparedStatement statement = this.connection.prepareStatement(query);
            for (int i = 0; i < tubeIds.size(); ++i) {
                statement.setString(i + 1, tubeIds.get(i));
            }
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String tubeId = resultSet.getString("tube_id");
                String batchId = resultSet.getString("batch_id");
                String compoundId = resultSet.getString("compound_id");
                BatchImpl batch = new BatchImpl(batchId, compoundId);
                TubeImpl tube = new TubeImpl(tubeId, batch);
                tubes.add(tube);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tubes;
    }

    @Override
    public List<Project> searchProjects(ProjectQuery query) throws SQLException {
        ArrayList<Project> result = new ArrayList<Project>();
        StringBuilder sb = new StringBuilder("SELECT * FROM project WHERE 1=1");
        if (query.getName() != null) {
            sb.append(" AND name LIKE ?");
        }
        PreparedStatement statement = this.connection.prepareStatement(sb.toString());
        int parameterIndex = 1;
        if (query.getName() != null) {
            statement.setString(parameterIndex, "%" + query.getName() + "%");
        }
        ResultSet resultSet = statement.executeQuery();
        while (resultSet.next()) {
            String id = resultSet.getString("id");
            String name = resultSet.getString("name");
            result.add(new ProjectImpl(id, name));
        }
        return result;
    }

    @Override
    public List<Assay> searchAssays(AssayQuery query) throws SQLException {
        HashSet<Integer> assayIds = new HashSet<Integer>();
        StringBuilder sqlBuilder = new StringBuilder("SELECT id FROM assay");
        if (query.getProjectId() != null) {
            sqlBuilder.append(" WHERE project_id = ?");
        }
        try (PreparedStatement statement = this.connection.prepareStatement(sqlBuilder.toString());){
            if (query.getProjectId() != null) {
                statement.setString(1, query.getProjectId());
            }
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int id = resultSet.getInt("id");
                    assayIds.add(id);
                }
            }
        }
        return DBAssay.fetchAssays(this.connection, assayIds);
    }

    @Override
    public int getNumberOfMeasurements(Assay assay) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SELECT COUNT(*) FROM assay_result WHERE assay_id = ?");
        statement.setInt(1, assay.getId());
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return 0;
    }

    @Override
    public Map<String, Compound> fetchCompounds(List<String> ids) {
        ArrayList<CompoundImpl> compounds = new ArrayList<CompoundImpl>();
        HashMap<String, Compound> resolved_compounds = new HashMap<String, Compound>();
        try {
            String query = "SELECT * FROM compound WHERE id = ?";
            PreparedStatement statement = this.connection.prepareStatement(query);
            for (String id : ids) {
                statement.setString(1, id);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String idcode = resultSet.getString("idcode");
                    String idcodeCoordinates = resultSet.getString("idcode_coordinates");
                    CompoundImpl compound = new CompoundImpl(id, idcode, idcodeCoordinates);
                    compounds.add(compound);
                    resolved_compounds.put(id, compound);
                }
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resolved_compounds;
    }

    @Override
    public List<Batch> fetchBatches(List<String> identifiers) {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        try {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("SELECT id, compound_id FROM batch WHERE id IN (");
            for (int i = 0; i < identifiers.size(); ++i) {
                queryBuilder.append("?");
                if (i >= identifiers.size() - 1) continue;
                queryBuilder.append(", ");
            }
            queryBuilder.append(")");
            String query = queryBuilder.toString();
            PreparedStatement statement = this.connection.prepareStatement(query);
            for (int i = 0; i < identifiers.size(); ++i) {
                statement.setString(i + 1, identifiers.get(i));
            }
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                String compoundId = resultSet.getString("compound_id");
                BatchImpl batch = new BatchImpl(id, compoundId);
                batches.add(batch);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return batches;
    }
}

