/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayParameter;
import tech.molecules.chem.coredb.DataType;
import tech.molecules.chem.coredb.Project;
import tech.molecules.chem.coredb.sql.AssayImpl;
import tech.molecules.chem.coredb.sql.AssayParameterImpl;
import tech.molecules.chem.coredb.sql.DBProject;

public class DBAssay {
    public static List<Assay> fetchAssays(Connection connection, Set<Integer> ids) throws SQLException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder queryBuilder = new StringBuilder("SELECT assay.id AS assay_id, assay.name AS assay_name, assay.project_id AS assay_project_id , assay_parameter.name AS parameter_name, assay_parameter.id AS assay_parameter_id, assay_parameter.data_type AS assay_parameter_data_type FROM assay JOIN assay_parameter ON assay.id = assay_parameter.assay_id WHERE assay.id IN (");
        StringJoiner idPlaceholders = new StringJoiner(", ");
        for (Integer id : ids) {
            idPlaceholders.add("?");
        }
        queryBuilder.append(idPlaceholders);
        queryBuilder.append(") ORDER BY assay.id");
        PreparedStatement statement = connection.prepareStatement(queryBuilder.toString());
        int i = 1;
        for (Integer id : ids) {
            statement.setInt(i++, id);
        }
        ResultSet resultSet = statement.executeQuery();
        LinkedHashMap<Integer, AssayImpl> assayMap = new LinkedHashMap<Integer, AssayImpl>();
        HashMap<Integer, String> assayToProjectMap = new HashMap<Integer, String>();
        HashMap<String, Project> projects = new HashMap<String, Project>();
        while (resultSet.next()) {
            int assayId = resultSet.getInt("assay_id");
            AssayImpl assay = (AssayImpl)assayMap.get(assayId);
            if (assay == null) {
                String assayName = resultSet.getString("assay_name");
                String assayProject = resultSet.getString("assay_project_id");
                if (!projects.containsKey(assayProject)) {
                    Project pi = DBProject.fetchProjects(connection, Collections.singletonMap(assayProject, "").keySet()).get(0);
                    projects.put(pi.getId(), pi);
                }
                assay = new AssayImpl(assayId, assayName, (Project)projects.get(assayProject), new ArrayList<AssayParameter>());
                assayMap.put(assayId, assay);
                assayToProjectMap.put(assayId, assayProject);
            }
            String parameterName = resultSet.getString("parameter_name");
            String dataTypeName = resultSet.getString("assay_parameter_data_type");
            int assayParameterId = resultSet.getInt("assay_parameter_id");
            DataType dataType = DataType.fromValue(dataTypeName);
            AssayParameterImpl parameter = new AssayParameterImpl(assayParameterId, assay, dataType, parameterName);
            assay.getParameter().add(parameter);
        }
        return new ArrayList<Assay>(assayMap.values());
    }
}

