/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.sql;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayParameter;
import tech.molecules.chem.coredb.AssayResult;
import tech.molecules.chem.coredb.DataValue;
import tech.molecules.chem.coredb.Tube;

public class AssayResultImpl
implements AssayResult {
    private long id;
    private Assay assay;
    private Date date;
    private Tube tube;
    private Map<String, DataValue> dataValueMap;

    public AssayResultImpl(long id, Assay assay, Date date, Tube tube, Map<AssayParameter, DataValue> dataValueMap) {
        this.id = id;
        this.assay = assay;
        this.date = date;
        this.tube = tube;
        this.setDataValueMap(dataValueMap);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Assay getAssay() {
        return this.assay;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Tube getTube() {
        return this.tube;
    }

    @Override
    public String getCompoundId() {
        return this.tube.getBatch().getCompoundId();
    }

    public void setAssay(Assay assay) {
        this.assay = assay;
    }

    public void setDataValueMap(Map<AssayParameter, DataValue> dataValueMap) {
        HashMap<String, DataValue> map_i = new HashMap<String, DataValue>();
        if (dataValueMap == null || dataValueMap.isEmpty()) {
            this.dataValueMap = new HashMap<String, DataValue>();
        } else {
            dataValueMap.entrySet().stream().forEach(ki -> map_i.put(((AssayParameter)ki.getKey()).getName(), (DataValue)ki.getValue()));
            this.dataValueMap = map_i;
        }
    }

    @Override
    public DataValue getData(AssayParameter ap) {
        return this.dataValueMap.get(ap);
    }

    @Override
    public DataValue getData(String parameter_name) {
        return this.dataValueMap.get(parameter_name);
    }
}

