/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.ingest;

import com.actelion.research.chem.StereoMolecule;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayParameter;
import tech.molecules.chem.coredb.AssayQuery;
import tech.molecules.chem.coredb.AssayResult;
import tech.molecules.chem.coredb.Batch;
import tech.molecules.chem.coredb.Compound;
import tech.molecules.chem.coredb.CoreDBException;
import tech.molecules.chem.coredb.DataType;
import tech.molecules.chem.coredb.NumericDataValue;
import tech.molecules.chem.coredb.Project;
import tech.molecules.chem.coredb.Tube;
import tech.molecules.chem.coredb.sql.DBManager;
import tech.molecules.chem.coredb.sql.DBManagerHelper;
import tech.molecules.leet.chem.ChemUtils;

public class CSVIngestor_01 {
    public static DataType numericDataType = null;

    public static void ingestFile(DBManager coredb, String csvFile, int maxLines) {
        int lineCnt = 0;
        String cvsSplitBy = ",";
        HashMap<String, Triple<Project, Assay, AssayParameter>> targetNamesToAssay = new HashMap<String, Triple<Project, Assay, AssayParameter>>();
        HashMap<String, Pair> compoundToBatchAndTube = new HashMap<String, Pair>();
        numericDataType = DataType.NUMERIC;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            br.readLine();
            while ((line = br.readLine()) != null) {
                Object cta;
                if (lineCnt > maxLines) {
                    break;
                }
                String[] data = line.split(cvsSplitBy);
                String targetName = data[0];
                String targetId = data[1];
                String structureId = data[2];
                String chemicalStructure = data[3];
                double activityData = Double.NaN;
                try {
                    activityData = Double.parseDouble(data[4]);
                }
                catch (NumberFormatException e) {
                    System.out.println("[INFO] NaN");
                }
                String activityUnits = data[5];
                String coredb_id = null;
                AssayParameter ap = null;
                Tube ti = null;
                if (!targetNamesToAssay.containsKey(targetName)) {
                    cta = CSVIngestor_01.createTarget(coredb, targetName);
                    targetNamesToAssay.put(targetName, (Triple<Project, Assay, AssayParameter>)cta);
                }
                ap = (AssayParameter)((Triple)targetNamesToAssay.get(targetName)).getRight();
                if (!compoundToBatchAndTube.containsKey(structureId)) {
                    cta = CSVIngestor_01.createCompound(coredb, structureId, chemicalStructure);
                    if (cta == null) {
                        System.out.println("[INFO] skip line: " + line);
                        continue;
                    }
                    coredb_id = ((Compound)cta.getLeft()).getId();
                    compoundToBatchAndTube.put(structureId, Pair.of((Object)((Batch)cta.getMiddle()), (Object)((Tube)cta.getRight())));
                } else {
                    coredb_id = ((Batch)((Pair)compoundToBatchAndTube.get(structureId)).getLeft()).getCompoundId();
                }
                ti = (Tube)((Pair)compoundToBatchAndTube.get(structureId)).getRight();
                CSVIngestor_01.createActivityMeasurement(coredb, ap, ti, activityData);
                ++lineCnt;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Triple<Project, Assay, AssayParameter> createTarget(DBManager coredb, String target) {
        System.out.println("Creating target: " + target);
        try {
            Project proj = coredb.createProject(target, target);
            Assay assay = coredb.createAssay(target + "_IC50", proj);
            AssayParameter param = coredb.createAssayParameter(assay, numericDataType, "IC50");
            return Triple.of((Object)proj, (Object)assay, (Object)param);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Triple<Compound, Batch, Tube> createCompound(DBManager coredb, String structureId, String smiles) {
        System.out.println("Creating compound: " + structureId + ", SMILES: " + smiles);
        StereoMolecule mi = null;
        try {
            mi = ChemUtils.parseSmiles((String)smiles);
        }
        catch (Exception ex) {
            System.out.println("[INFO] smiles parsing failed: " + smiles);
            return null;
        }
        Compound ci = null;
        Batch bi = null;
        Tube ti = null;
        try {
            ci = coredb.createCompound("chembl_" + structureId, mi);
            bi = coredb.createBatch("batch_" + structureId, ci);
            ti = coredb.createTube("T_" + structureId, bi);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        catch (CoreDBException e) {
            throw new RuntimeException(e);
        }
        return Triple.of((Object)ci, (Object)bi, (Object)ti);
    }

    private static AssayResult createActivityMeasurement(DBManager coredb, AssayParameter ap, Tube ti, double measuredActivity) {
        System.out.println("Creating activity measurement: AssayParameter: " + ap.getName() + ", Structure ID: " + ti.getBatch().getCompoundId() + ", Measured Activity: " + measuredActivity);
        try {
            AssayResult ar = coredb.createAssayResult(ap.getAssay(), new Date(System.currentTimeMillis()), ti);
            coredb.addDataValue(ar, ap, new NumericDataValue(measuredActivity));
            return ar;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String db = "postgres";
        int rii = 1;
        String dbUrl = "";
        DBManager dbManager = null;
        try {
            if (db.equals("sqlite")) {
                dbUrl = "jdbc:sqlite:chemdb_test_" + rii + ".db";
                dbManager = DBManagerHelper.getSQLite(dbUrl);
            } else if (db.contains("h2db")) {
                dbUrl = "jdbc:h2:mem:";
                dbManager = DBManagerHelper.getH2(dbUrl);
            } else if (db.equals("postgres")) {
                dbUrl = "jdbc:postgresql://localhost:5432/leet_chem_01";
                dbManager = DBManagerHelper.getPostgres(dbUrl, "postgres", "a");
            }
            dbManager.createDatabaseSchema();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CSVIngestor_01.ingestFile(dbManager, "output_chembl_activities.csv", 2000000);
        try {
            List<Assay> assays = dbManager.searchAssays(new AssayQuery());
            System.out.println("assays:");
            for (Assay asi : assays) {
                System.out.println(String.format("%s %d", asi.getName(), dbManager.getNumberOfMeasurements(asi)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

