/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayQuery;
import tech.molecules.chem.coredb.sql.DBManager;

public class AssayTableModel
extends AbstractTableModel {
    private DBManager dbManager;
    private List<Assay> assays;
    private List<Assay> filteredAssays;
    private String[] columnNames = new String[]{"Assay Name", "Assay ID", "Project", "Number of Measurements"};
    private Map<Assay, Integer> numberOfResultsCache = new HashMap<Assay, Integer>();

    public AssayTableModel(DBManager dbManager) {
        this.dbManager = dbManager;
        this.assays = new ArrayList<Assay>();
        this.filteredAssays = new ArrayList<Assay>();
    }

    public void loadData() throws SQLException {
        this.assays = this.dbManager.searchAssays(new AssayQuery());
        this.filteredAssays = new ArrayList<Assay>(this.assays);
        this.fireTableDataChanged();
    }

    public void filterData(String searchString) {
        if (searchString == null || searchString.isEmpty()) {
            this.filteredAssays = new ArrayList<Assay>(this.assays);
        } else {
            String fSearchString = searchString.toLowerCase();
            this.filteredAssays = this.assays.stream().filter(assay -> assay.getName().toLowerCase().contains(fSearchString) || assay.getProject().getName().toLowerCase().contains(searchString)).collect(Collectors.toList());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.filteredAssays.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Assay assay = this.filteredAssays.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return assay.getName();
            }
            case 1: {
                return assay.getId();
            }
            case 2: {
                return assay.getProject().getName();
            }
            case 3: {
                if (!this.numberOfResultsCache.containsKey(assay)) {
                    try {
                        this.numberOfResultsCache.put(assay, -1);
                        this.numberOfResultsCache.put(assay, this.dbManager.getNumberOfMeasurements(assay));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                return this.numberOfResultsCache.get(assay);
            }
        }
        return null;
    }
}

