/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tech.molecules.chem.coredb.AssayResult;
import tech.molecules.chem.coredb.DataValue;
import tech.molecules.chem.coredb.aggregation.AggregatedNumericValue;
import tech.molecules.chem.coredb.aggregation.AssayResultFilterInfo;
import tech.molecules.chem.coredb.aggregation.CoreDBFilterInfo;
import tech.molecules.chem.coredb.aggregation.FilteredAssayInfo;
import tech.molecules.chem.coredb.aggregation.NumericAggregationInfo;

public class NumericAggregator {
    public static AggregatedNumericValue aggregate(NumericAggregationInfo info, List<AssayResult> filteredResults) {
        List<Double> values = new ArrayList<Double>();
        for (AssayResult ri : filteredResults) {
            double vi;
            DataValue xvi = ri.getData(info.getParameterName());
            if (xvi == null || Double.isNaN(vi = xvi.getAsDouble())) continue;
            if (Double.isFinite(info.getFixedLB())) {
                vi = Math.max(vi, info.getFixedLB());
            }
            if (Double.isFinite(info.getFixedUB())) {
                vi = Math.min(vi, info.getFixedUB());
            }
            if (info.isHandleLogarithmic() && vi <= 0.0) continue;
            values.add(vi);
        }
        double aggregated = Double.NaN;
        if (info.isHandleLogarithmic()) {
            values = values.stream().map(xi -> Math.log(xi)).collect(Collectors.toList());
        }
        aggregated = NumericAggregator.aggregate(info.getMethod(), values);
        if (info.isHandleLogarithmic()) {
            aggregated = Math.exp(aggregated);
        }
        return new AggregatedNumericValue(aggregated, info, filteredResults, values.stream().mapToDouble(xi -> xi).toArray());
    }

    public static double aggregate(String method, List<Double> values) {
        double aggregated = Double.NaN;
        if (values.size() == 0) {
            return aggregated;
        }
        boolean handled = false;
        if (method.equals("mean")) {
            aggregated = values.stream().mapToDouble(xi -> xi).summaryStatistics().getAverage();
            handled = true;
        }
        if (!handled) {
            System.out.println("[WARN] unknown aggregation method " + method + " -> fallback to mean");
            aggregated = values.stream().mapToDouble(xi -> xi).summaryStatistics().getAverage();
            handled = true;
        }
        return aggregated;
    }

    public static List<AssayResult> filter(FilteredAssayInfo filterInfo, List<AssayResult> in) {
        ArrayList<AssayResult> results = new ArrayList<AssayResult>(in.stream().filter(xi -> NumericAggregator.filter(filterInfo, xi)).collect(Collectors.toList()));
        return results;
    }

    public static boolean filter(FilteredAssayInfo filterInfo, AssayResult in) {
        boolean ok = true;
        if (ok && in.getAssay().getId() != filterInfo.assayID.intValue()) {
            ok = false;
        }
        if (ok && filterInfo.assayResultFilter != null) {
            ok = NumericAggregator.filterAssayResultFilter(filterInfo.assayResultFilter, in);
        }
        if (ok && filterInfo.coreDBFilter != null) {
            ok = NumericAggregator.filterCoreDBFilter(filterInfo.coreDBFilter, in);
        }
        return ok;
    }

    public static boolean filterAssayResultFilter(AssayResultFilterInfo info, AssayResult xi) {
        return true;
    }

    public static boolean filterCoreDBFilter(CoreDBFilterInfo info, AssayResult xi) {
        boolean ok = true;
        Map<String, CoreDBFilterInfo.AttrFilterInfo> paramFilters = info.getAttrFiltersSorted();
        for (String ki : paramFilters.keySet()) {
            DataValue vi = xi.getData(ki);
            if (paramFilters.get((Object)ki).values.contains(vi.getAsText())) continue;
            ok = false;
            break;
        }
        return ok;
    }
}

