/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoreDBFilterInfo {
    @JsonPropertyDescription(value="attribute filters, all attributes not in this list are not considered for filtering")
    @JsonProperty(value="attrFilters")
    private List<AttrFilterInfo> attrFilters;

    public List<AttrFilterInfo> getAttrFilters() {
        return this.attrFilters;
    }

    public CoreDBFilterInfo() {
        this(new ArrayList<AttrFilterInfo>());
    }

    public CoreDBFilterInfo(List<AttrFilterInfo> attrFilters) {
        this.attrFilters = attrFilters;
    }

    public Map<String, AttrFilterInfo> getAttrFiltersSorted() {
        HashMap<String, AttrFilterInfo> fs = new HashMap<String, AttrFilterInfo>();
        for (AttrFilterInfo ati : this.attrFilters) {
            fs.put(ati.attr, ati);
        }
        return fs;
    }

    public void CoreDBFilterInfo(String attrName, AttrFilterInfo fi_new) {
        if (this.getAttrFiltersSorted().containsKey(attrName)) {
            this.attrFilters.removeAll(this.attrFilters.stream().filter(ai -> ai.attr.equals(attrName)).collect(Collectors.toList()));
        }
        this.attrFilters.add(fi_new);
    }

    public static class AttrFilterInfo {
        @JsonPropertyDescription(value="attribute name to be filtered")
        @JsonProperty(value="attr")
        public final String attr;
        @JsonPropertyDescription(value="accepted values for attribute")
        @JsonProperty(value="values")
        public final List<String> values;

        public AttrFilterInfo(String attr, List<String> values) {
            this.attr = attr;
            this.values = values;
        }
    }
}

