package com.miam.sdk.components.recipeDetail.success.info

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.RectangleShape
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.miam.sdk.components.baseComponent.counter.CounterParameters
import com.miam.sdk.components.baseComponent.likeButton.LikeButton
import com.miam.sdk.di.TemplateDI

class RecipeDetailInfoImp: RecipeDetailInfo {
    @Composable
    override fun Content(params: RecipeDetailInfoParameters) {
        params.recipe.attributes?.let { attributes ->
            Box {
                AsyncImage(
                    model = attributes.mediaUrl,
                    contentDescription = "Recipe Image",
                    contentScale = ContentScale.Crop,
                    modifier = Modifier
                        .height(280.dp)
                        .fillMaxWidth()
                )
                if (params.isLikeEnable) {
                    Row(
                        horizontalArrangement = Arrangement.End,
                        verticalAlignment = Alignment.CenterVertically,
                        modifier = Modifier
                            .padding(16.dp)
                            .fillMaxWidth()
                    ) {
                        LikeButton(RectangleShape, recipeId = params.recipe.id).Content()
                    }
                }
                if (params.showGuestCounter) {
                    Box(
                        Modifier
                            .align(Alignment.BottomEnd)
                            .padding(16.dp)
                    ) {

                        TemplateDI.recipeDetail.success.info.counter?.view?.Content(
                            params = CounterParameters(
                                initialCount = params.guestCount,
                                isDisable = params.isUpdating,
                                isLoading = params.isUpdating,
                                onCounterChanged = { counterValue -> params.updateGuest(counterValue) },
                                minValue = 1,
                                maxValue = 99
                            )
                        ) ?: TemplateDI.defaultViews.counter?.view?.Content(
                            params = CounterParameters(
                                initialCount = params.guestCount,
                                isDisable = params.isUpdating,
                                isLoading = params.isUpdating,
                                onCounterChanged = { counterValue -> params.updateGuest(counterValue) },
                                minValue = 1,
                                maxValue = 99
                            )
                        )
                    }
                }
            }
        }
    }
}