package com.miam.sdk.components.mealPlanner.recipe

import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfig
import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfig
import com.miam.sdk.components.mealPlanner.recipe.placeholder.MealPlannerRecipePlaceholderConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.success.MealPlannerRecipeCardSuccessConfig
import com.miam.sdk.components.mealPlanner.recipe.success.MealPlannerRecipeCardSuccessConfigBuilder

class MealPlannerRecipeCardConfigBuilder {
    var success: MealPlannerRecipeCardSuccessConfig = MealPlannerRecipeCardSuccessConfig()
    var loading: MealPlannerRecipeLoadingConfig = MealPlannerRecipeLoadingConfig()
    var placeholder: MealPlannerRecipePlaceholderConfig = MealPlannerRecipePlaceholderConfig()


    inline fun success(init: MealPlannerRecipeCardSuccessConfigBuilder.() -> Unit) {
        this.success = MealPlannerRecipeCardSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: MealPlannerRecipeLoadingConfigBuilder.() -> Unit) {
        this.loading = MealPlannerRecipeLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun placeholder(init: MealPlannerRecipePlaceholderConfigBuilder.() -> Unit) {
        this.placeholder = MealPlannerRecipePlaceholderConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MealPlannerRecipeCardConfig {
        return MealPlannerRecipeCardConfig(success, loading, placeholder)
    }
}