package com.miam.sdk.components.mealPlanner.basketPreview.footer

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Colors.primary
import com.miam.kmm_miam_sdk.android.theme.Typography.bodyBold


class MealPlannerBasketPreviewFooterImp: MealPlannerBasketPreviewFooter {

    @Composable
    override fun Content(params: MealPlannerBasketPreviewFooterParameters) {
        Row(
            Modifier
                .background(Colors.white)
                .padding(8.dp)
        ) {
            Box(
                Modifier
                    .fillMaxWidth()
                    .border(
                        BorderStroke(1.dp, primary),
                        shape = RoundedCornerShape(8.dp)
                    )
                    .clickable {
                        if (params.isProcessing) return@clickable
                        params.confirmAction()
                    }
            ) {
                Text(
                    modifier = Modifier
                        .padding(8.dp)
                        .fillMaxWidth(),
                    text = Localisation.Budget.mealPlannerFinalize.localised,
                    textAlign = TextAlign.Center,
                    color = primary,
                    style = bodyBold
                )
            }
        }
    }
}