package com.miam.sdk.components.mealPlanner

import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfig
import com.miam.sdk.components.mealPlanner.basketPreview.MealPlannerBasketPreviewConfigBuilder
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfig
import com.miam.sdk.components.mealPlanner.callToAction.MealPlannerCallToActionConfigBuilder
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfig
import com.miam.sdk.components.mealPlanner.form.MealPlannerFormConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.MealPlannerMealsConfig
import com.miam.sdk.components.mealPlanner.meals.MealPlannerMealsConfigBuilder
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfig
import com.miam.sdk.components.mealPlanner.recap.MealPlannerRecapConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfig
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfigBuilder
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfig
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchConfigBuilder
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfig
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyConfigBuilder

class MealPlannerConfigBuilder {

    var recipeCard: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()
    var callToAction: MealPlannerCallToActionConfig = MealPlannerCallToActionConfig()
    var form: MealPlannerFormConfig = MealPlannerFormConfig()
    var search: MealPlannerSearchConfig = MealPlannerSearchConfig()
    var searchEmpty: MealPlannerSearchEmptyConfig = MealPlannerSearchEmptyConfig()
    var recap: MealPlannerRecapConfig = MealPlannerRecapConfig()
    var basketPreview: MealPlannerBasketPreviewConfig = MealPlannerBasketPreviewConfig()
    var meals: MealPlannerMealsConfig = MealPlannerMealsConfig()


    inline fun basketPreview(init: MealPlannerBasketPreviewConfigBuilder.() -> Unit) {
        this.basketPreview = MealPlannerBasketPreviewConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipeCard(init: MealPlannerRecipeCardConfigBuilder.() -> Unit) {
        this.recipeCard = MealPlannerRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun callToAction(init: MealPlannerCallToActionConfigBuilder.() -> Unit) {
        this.callToAction = MealPlannerCallToActionConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun form(init: MealPlannerFormConfigBuilder.() -> Unit) {
        this.form = MealPlannerFormConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun searchEmpty(init: MealPlannerSearchEmptyConfigBuilder.() -> Unit) {
        this.searchEmpty = MealPlannerSearchEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recap(init: MealPlannerRecapConfigBuilder.() -> Unit) {
        this.recap = MealPlannerRecapConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun search(init: MealPlannerSearchConfigBuilder.() -> Unit) {
        this.search = MealPlannerSearchConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun meals(init: MealPlannerMealsConfigBuilder.() -> Unit) {
        this.meals = MealPlannerMealsConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerConfig {
        return MealPlannerConfig(
            basketPreview,
            recipeCard,
            callToAction,
            meals,
            form,
            searchEmpty,
            search,
            recap
        )
    }
}