package com.miam.sdk.components.itemSelector.loading

import androidx.compose.animation.core.FastOutLinearInEasing
import androidx.compose.animation.core.animateFloat
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Colors

class ItemSelectorLoadingImp : ItemSelectorLoading {
    @Composable
    override fun Content() {
        val shimmerColors = listOf(
            Color.LightGray.copy(alpha = 0.6F),
            Color.LightGray.copy(alpha = 0.2F),
            Color.LightGray.copy(alpha = 0.6F)
        )
        val transition = rememberInfiniteTransition()
        val translateAnimation = transition.animateFloat(
            initialValue = 0f,
            targetValue = 1000f,
            animationSpec = infiniteRepeatable(
                animation = tween(
                    durationMillis = 1000,
                    easing = FastOutLinearInEasing
                )
            )
        )
        val brush = Brush.linearGradient(
            colors = shimmerColors,
            start = Offset.Zero,
            end = Offset(
                x = translateAnimation.value,
                y = translateAnimation.value
            )
        )
        for (i in 0..3) {
            ShimmerItem(brush)
        }
    }
}

@Composable
fun ShimmerItem(brush: Brush) {
    Column {
        Surface(modifier = Modifier.fillMaxWidth()) {
            Column(modifier = Modifier.padding(16.dp), verticalArrangement = Arrangement.spacedBy(8.dp)) {
                Row(horizontalArrangement = Arrangement.spacedBy(16.dp)) {
                    Spacer(
                        modifier = Modifier
                            .size(88.dp)
                            .padding(4.dp)
                            .fillMaxSize()
                            .clip(RoundedCornerShape(8.dp))
                            .background(brush = brush)
                    )
                    Column(verticalArrangement = Arrangement.spacedBy(4.dp)) {
                        Spacer(
                            modifier = Modifier
                                .height(18.dp)
                                .width(130.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                        Spacer(
                            modifier = Modifier
                                .height(18.dp)
                                .fillMaxWidth()
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                        Spacer(
                            modifier = Modifier
                                .padding(top = 8.dp)
                                .height(20.dp)
                                .width(40.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                    }
                }
                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    horizontalArrangement = Arrangement.SpaceBetween,
                    modifier = Modifier.fillMaxWidth()
                ) {
                    Spacer(
                        modifier = Modifier
                            .height(24.dp)
                            .width(60.dp)
                            .clip(RoundedCornerShape(100))
                            .background(brush = brush)
                    )
                    Spacer(
                        modifier = Modifier
                            .height(28.dp)
                            .width(110.dp)
                            .clip(RoundedCornerShape(6.dp))
                            .background(brush = brush)
                    )
                }
            }
        }
        Surface(color = Colors.border, modifier = Modifier.fillMaxWidth()) {
            Spacer(Modifier.size(1.dp))
        }
    }
}
