package com.miam.sdk.components.favoritePage

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderConfig
import com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder

class FavoritePageConfigBuilder {

    var empty: EmptyPageConfig? = null
    var lazyListLoader: LazyListLoaderConfig = LazyListLoaderConfig()
    var loading: LoaderConfig? = null
    var spacingBetweenCard: Int = 8

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun lazyListLoader(init: LazyListLoaderConfigBuilder.() -> Unit) {
        this.lazyListLoader = LazyListLoaderConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): FavoritePageConfig {
        return FavoritePageConfig(spacingBetweenCard, empty, lazyListLoader, loading)
    }
}