package com.miam.sdk.components.baseComponent.recipesPage.success

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.lazy.grid.GridCells
import androidx.compose.foundation.lazy.grid.GridItemSpan
import androidx.compose.foundation.lazy.grid.LazyVerticalGrid
import androidx.compose.foundation.lazy.grid.itemsIndexed
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.model.Recipe
import com.miam.sdk.components.baseComponent.lazyListLoader.LazyListLoaderParameters
import com.miam.sdk.components.baseComponent.recipesPage.success.title.RecipesPageSuccessTitleParameters
import com.miam.sdk.components.recipeJourney.RecipeJourney
import com.miam.sdk.di.TemplateDI

@Composable
fun RecipesPageSuccess(
    title: String,
    subtitle: String? = null,
    recipes: List<Recipe>,
    isFetching: Boolean,
    loadPage: () -> Unit
) {
    LazyVerticalGrid(
        modifier = Modifier.fillMaxSize(),
        contentPadding = PaddingValues(TemplateDI.recipesPage.success.listPadding.dp),
        columns = GridCells.Fixed(TemplateDI.recipesPage.success.numberOfColumns),
        verticalArrangement = Arrangement.spacedBy(TemplateDI.recipesPage.success.verticalSpacing.dp),
        horizontalArrangement = Arrangement.spacedBy(TemplateDI.recipesPage.success.horizontalSpacing.dp)
    ) {
        item(span = { GridItemSpan(TemplateDI.recipesPage.success.numberOfColumns) }) {
            TemplateDI.recipesPage.success.title.view.Content(
                params = RecipesPageSuccessTitleParameters(title, subtitle)
            )
        }
        itemsIndexed(recipes, { _, recipe -> recipe.id }) { index, recipe ->
            RecipeJourney.View(recipe = recipe)
            if (index == recipes.lastIndex) {
                loadPage()
            }
        }
        item(span = { GridItemSpan(TemplateDI.recipesPage.success.numberOfColumns) }) {
            TemplateDI.recipesPage.success.lazyFetchLoader.view.Content(
                params = LazyListLoaderParameters(
                    isFetching
                )
            )
        }
    }

}