package com.miam.sdk.components.sponsorDetail

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.localisation.Localisation
import com.miam.core.model.Sponsor
import com.miam.core.viewModels.sponsorDetailViewModel.SponsorDetailViewModelImpl
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageParameters
import com.miam.sdk.components.baseComponent.loader.LoaderParameters
import com.miam.sdk.components.sponsorDetail.success.SponsorDetailSuccessView
import com.miam.sdk.di.TemplateDI

class SponsorDetail @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private val vmSponsorDetail: SponsorDetailViewModelImpl = SponsorDetailViewModelImpl()
    private var previous: () -> Unit = {}
    private var sponsorLogo: String? = null

    fun bind(sponsor: Sponsor, previous: () -> Unit) {
        vmSponsorDetail.fetchSponsorBlockByIds(sponsor)
        this.previous = previous
        sponsor.attributes?.logoUrl?.let {
            sponsorLogo = it
        }
    }

    fun bind(sponsorId: String, previous: () -> Unit) {
        vmSponsorDetail.fetchSponsorBlockByIds(sponsorId)
        this.previous = previous
    }

    @Composable
    override fun Content() {
        val state by vmSponsorDetail.state.collectAsState()

        ManagementResourceState(
            resourceState = state.sponsorBlocks,
            successView = { sponsorBlocks ->
                requireNotNull(sponsorBlocks)
                SponsorDetailSuccessView(sponsorBlocks, previous, sponsorLogo)
            },
            loadingView = {
                TemplateDI.sponsorDetail.loading?.view?.Content(params = LoaderParameters)
                    ?: TemplateDI.defaultViews.loading.view.Content(params = LoaderParameters)
            },
            emptyView = {
                val params = EmptyPageParameters(
                    title = Localisation.SponsorDetail.emptyTitle.localised,
                    subtitle = Localisation.SponsorDetail.emptySubtitle.localised,
                    haveAnAction = true,
                    actionText = Localisation.SponsorDetail.emptyCta.localised
                ) {
                    previous()
                }
                TemplateDI.sponsorDetail.empty?.view?.Content(params = params)
                    ?: TemplateDI.defaultViews.empty.view.Content(params = params)
            }
        )
    }

}