package com.miam.sdk.components.recipeCarousel

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.recipeCarousel.empty.RecipeCarouselEmptyParameters
import com.miam.sdk.components.recipeCarousel.loader.RecipeCarouselLoaderParameters
import com.miam.sdk.components.recipeCarousel.success.RecipeCarouselSuccess
import com.miam.core.model.SuggestionsCriteria
import com.miam.core.viewModels.recipeCarousel.RecipeCarouselContract
import com.miam.core.viewModels.recipeCarousel.RecipeCarouselViewModel
import com.miam.sdk.di.TemplateDI

class RecipeCarousel @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private var vmRecipeCarousel: RecipeCarouselViewModel = RecipeCarouselViewModel()
    private var recipeListSize = 4

    fun bind(
        productId: String? = null,
        criteria: SuggestionsCriteria? = null,
        recipeListSize: Int = 4
    ) {
        if (productId != null) {
            vmRecipeCarousel.setEvent(RecipeCarouselContract.Event.GetRecipeSuggestionsFromId(productId, recipeListSize))
        } else if (criteria != null) {
            vmRecipeCarousel.setEvent(RecipeCarouselContract.Event.GetRecipeSuggestionsFromCriteria(criteria, recipeListSize))
        }

        this.recipeListSize = recipeListSize
        return
    }

    @Composable
    override fun Content() {
        val state by vmRecipeCarousel.uiState.collectAsState()

        ManagementResourceState(
            resourceState = state.suggestions,
            successView = { suggestions ->
                requireNotNull(suggestions)
                RecipeCarouselSuccess(suggestions, context)
            },
            loadingView = {
                TemplateDI.recipeCarousel.loader.view.Content(
                    params =
                    RecipeCarouselLoaderParameters(recipeListSize)
                )

            },
            emptyView = {
                TemplateDI.recipeCarousel.empty.view.Content(params = RecipeCarouselEmptyParameters)
            }
        )
    }
}