package com.miam.sdk.components.mealPlanner.search.empty

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation

class MealPlannerSearchEmptyImp: MealPlannerSearchEmpty {
    @Composable
    override fun Content(mealPlannerSearchEmptyParameters: MealPlannerSearchEmptyParameters) {
        Column(
            Modifier.padding(16.dp),
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            Text(
                text = Localisation.Budget.mealPlannerSearchFailed.localised,
                style = com.miam.kmm_miam_sdk.android.theme.Typography.bodyBold,
                modifier = Modifier.fillMaxWidth()
            )
            Spacer(modifier = Modifier.height(8.dp))
            Image(
                painter = painterResource(com.miam.kmm_miam_sdk.android.ressource.Image.miamEmpty),
                contentDescription = null,
                modifier = Modifier.height(250.dp)
            )
            Spacer(modifier = Modifier.height(8.dp))
            Text(
                text = Localisation.Budget.mealPlannerSearchFailed.localised,
                color = com.miam.kmm_miam_sdk.android.theme.Colors.grey,
                style = com.miam.kmm_miam_sdk.android.theme.Typography.bodySmall
            )
        }
    }
}