package com.miam.sdk.components.mealPlanner.meals

import com.miam.sdk.components.mealPlanner.meals.empty.MealPlannerEmptyConfig
import com.miam.sdk.components.mealPlanner.meals.empty.MealPlannerEmptyConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.footer.MealPlannerFooterConfig
import com.miam.sdk.components.mealPlanner.meals.footer.MealPlannerFooterConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.loading.MealPlannerLoadingConfig
import com.miam.sdk.components.mealPlanner.meals.loading.MealPlannerLoadingConfigBuilder
import com.miam.sdk.components.mealPlanner.meals.toolbar.MealPlannerToolbarConfig
import com.miam.sdk.components.mealPlanner.meals.toolbar.MealPlannerToolbarConfigBuilder
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfig
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCardConfigBuilder

class MealPlannerMealsConfigBuilder {

    var empty: MealPlannerEmptyConfig = MealPlannerEmptyConfig()
    var footer: MealPlannerFooterConfig = MealPlannerFooterConfig()
    var loading: MealPlannerLoadingConfig = MealPlannerLoadingConfig()
    var toolbar: MealPlannerToolbarConfig = MealPlannerToolbarConfig()
    var recipe: MealPlannerRecipeCardConfig = MealPlannerRecipeCardConfig()

    inline fun empty(init: MealPlannerEmptyConfigBuilder.() -> Unit) {
        this.empty = MealPlannerEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun footer(init: MealPlannerFooterConfigBuilder.() -> Unit) {
        this.footer = MealPlannerFooterConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: MealPlannerLoadingConfigBuilder.() -> Unit) {
        this.loading = MealPlannerLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun toolbar(init: MealPlannerToolbarConfigBuilder.() -> Unit) {
        this.toolbar = MealPlannerToolbarConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipe(init: MealPlannerRecipeCardConfigBuilder.() -> Unit) {
        this.recipe = MealPlannerRecipeCardConfigBuilder()
            .apply(init)
            .build()
    }


    @PublishedApi
    internal fun build(): MealPlannerMealsConfig {
        return MealPlannerMealsConfig(
            empty,
            footer,
            loading,
            toolbar,
            recipe
        )
    }
}