package com.miam.sdk.components.mealPlanner.basketPreview.success.found

import com.miam.sdk.components.mealPlanner.basketPreview.success.found.products.FoundProductConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.found.products.FoundProductConfigBuilder
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header.NotInBasketProductHeaderConfig
import com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header.NotInBasketProductHeaderConfigBuilder

class FoundProductsConfigBuilder {
    var header: NotInBasketProductHeaderConfig = NotInBasketProductHeaderConfig()
    var product: FoundProductConfig = FoundProductConfig()

    inline fun header(init: NotInBasketProductHeaderConfigBuilder.() -> Unit) {
        this.header = NotInBasketProductHeaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun product(init: FoundProductConfigBuilder.() -> Unit) {
        this.product = FoundProductConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): FoundProductsConfig {
        return FoundProductsConfig(product)
    }
}