package com.miam.sdk.components.baseComponent.myMealButton

import com.miam.sdk.components.baseComponent.myMealButton.empty.MyMealButtonEmptyConfig
import com.miam.sdk.components.baseComponent.myMealButton.empty.MyMealButtonEmptyConfigBuilder
import com.miam.sdk.components.baseComponent.myMealButton.success.MyMealButtonSuccessConfig
import com.miam.sdk.components.baseComponent.myMealButton.success.MyMealButtonSuccessConfigBuilder

class MyMealButtonConfigBuilder {
    var empty : MyMealButtonEmptyConfig = MyMealButtonEmptyConfig()
    var success : MyMealButtonSuccessConfig = MyMealButtonSuccessConfig()

    inline fun empty(init: MyMealButtonEmptyConfigBuilder.() -> Unit) {
        this.empty = MyMealButtonEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: MyMealButtonSuccessConfigBuilder.() -> Unit) {
        this.success = MyMealButtonSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): MyMealButtonConfig {
        return MyMealButtonConfig(
            empty,
            success
        )
    }
}