package com.miam.sdk.components.baseComponent

import com.miam.sdk.components.baseComponent.counter.CounterConfig
import com.miam.sdk.components.baseComponent.counter.CounterConfigBuilder
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.errorPage.ErrorPageConfig
import com.miam.sdk.components.baseComponent.errorPage.ErrorPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder

class DefaultViewsConfigBuilder {
    var empty: EmptyPageConfig = EmptyPageConfig()
    var loading: LoaderConfig = LoaderConfig()
    var error: ErrorPageConfig = ErrorPageConfig()
    var counter: CounterConfig? = CounterConfig()

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun error(init: ErrorPageConfigBuilder.() -> Unit) {
        error = ErrorPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun counter(init: CounterConfigBuilder.() -> Unit) {
        counter = CounterConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): DefaultViewsConfig {
        return DefaultViewsConfig(empty, loading, error)
    }
}