package com.miam.sdk.components.sponsorDetail

import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfig
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageConfigBuilder
import com.miam.sdk.components.baseComponent.loader.LoaderConfig
import com.miam.sdk.components.baseComponent.loader.LoaderConfigBuilder
import com.miam.sdk.components.sponsorDetail.success.SponsorDetailSuccessConfig
import com.miam.sdk.components.sponsorDetail.success.SponsorDetailSuccessConfigBuilder

class SponsorDetailConfigBuilder {

    var loading: LoaderConfig? = null
    var empty: EmptyPageConfig? = null
    var success: SponsorDetailSuccessConfig = SponsorDetailSuccessConfig()

    inline fun loading(init: LoaderConfigBuilder.() -> Unit) {
        this.loading = LoaderConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: EmptyPageConfigBuilder.() -> Unit) {
        this.empty = EmptyPageConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun success(init: SponsorDetailSuccessConfigBuilder.() -> Unit) {
        this.success = SponsorDetailSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): SponsorDetailConfig {
        return SponsorDetailConfig(loading, empty, success)
    }
}