package com.miam.sdk.components.recipeDetail.success.steps

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.CircleChips
import com.miam.kmm_miam_sdk.android.ui.components.common.RoundedCheckbox

class RecipeDetailStepsImp: RecipeDetailSteps {
    @Composable
    override fun Content(params: RecipeDetailStepsParamters) {

        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(8.dp)
        ) {
            Text(
                text = Localisation.Recipe.steps.localised,
                style = Typography.subtitleBold,
                color = Colors.black
            )
            params.steps.forEachIndexed { index, recipeStep ->
                recipeStep.attributes?.stepDescription?.let { description ->
                    Step(
                        index,
                        description
                    )
                }
            }
            Spacer(modifier = Modifier.padding(vertical = 50.dp))
        }
    }

    @Composable
    fun Step(stepNumber: Int, description: String) {
        Surface(Modifier.clip(RoundedCornerShape(16.dp))) {
            Row(
                horizontalArrangement = Arrangement.Start,
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(vertical = 16.dp)
            ) {
                CircleChips((stepNumber + 1).toString())
                Text(
                    text = description,
                    fontSize = 16.sp,
                    modifier = Modifier
                        .weight(1F)
                        .padding(horizontal = 8.dp, vertical = 4.dp)

                )
            }
        }
    }
}