package com.miam.sdk.components.price.footer

import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.price.footer.success.FooterPriceSuccessParameters
import com.miam.core.viewModels.pricing.RecipePricingViewModel
import com.miam.sdk.di.TemplateDI

@Composable
fun FooterPrice(
    recipeId: String,
    guestNumber: Int,
) {
    val vmPrice = RecipePricingViewModel()
    vmPrice.setRecipe(recipeId, guestNumber)
    FooterPriceStateManager(vmPrice)
    LaunchedEffect(Unit) { vmPrice.listenBasketChanges() }
    DisposableEffect(Unit) { onDispose { vmPrice.dispose() } }
}

@Composable
fun FooterPriceStateManager(
    vmPrice: RecipePricingViewModel,
) {
    val state by vmPrice.uiState.collectAsState()
    var isLoaded by remember { mutableStateOf(false) }
    Box {
        ManagementResourceState(resourceState = state.price,
            successView = { price ->
                requireNotNull(price)
                LaunchedEffect(price) { isLoaded = true }
                TemplateDI.price.footerPrice.success.view.Content(params = FooterPriceSuccessParameters(price))
            },
            emptyView = { TemplateDI.price.footerPrice.empty.view.Content() },
            loadingView = { TemplateDI.price.footerPrice.loading.view.Content() }
        )
    }
}