package com.miam.sdk.components.preferences.success.ingredientSection

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.kmm_miam_sdk.android.utils.FlowLayout

class PreferencesIngredientSectionImp: PreferencesIngredientSection {
    @Composable
    override fun Content(params: PreferencesIngredientSectionParameters) {
        Column(Modifier.fillMaxWidth()) {
            Text(
                text = Localisation.Preferences.tastesTitle.localised,
                style = Typography.bodyBold,
                modifier = Modifier.padding(bottom = 4.dp)
            )
            Text(text = Localisation.Preferences.tastesSubtitle.localised, style = Typography.bodySmall)
            Spacer(modifier = Modifier.height(16.dp))
            FlowLayout(verticalSpacing = 4.dp, horizontalSpacing = 8.dp) {
                for (checkableTag in params.ingredientsTag) {
                    Clickable(onClick = { params.togglePreference(checkableTag.tag.id) }) {
                        Box(
                            Modifier
                                .border(
                                    BorderStroke(1.dp, if (checkableTag.isChecked) Colors.primary else Color.Gray),
                                    RoundedCornerShape(50)
                                )
                                .clip(RoundedCornerShape(50))
                                .background(if (checkableTag.isChecked) Colors.primary else Colors.white)
                        ) {
                            Row(Modifier.padding(horizontal = 8.dp, vertical = 11.dp)) {
                                checkableTag.tag.attributes?.name?.let {
                                    Text(
                                        text = it,
                                        color = if (checkableTag.isChecked) Colors.white else Color.Gray
                                    )
                                }

                                if (checkableTag.isChecked) {
                                    Spacer(modifier = Modifier.width(4.dp))
                                    Image(
                                        painter = painterResource(Image.check),
                                        contentDescription = null,
                                        colorFilter = ColorFilter.tint(Colors.white),
                                        modifier = Modifier.size(18.dp)
                                    )
                                }
                            }
                        }
                    }
                }
                Clickable(onClick = params.goToSearch) {
                    Box(
                        Modifier
                            .border(BorderStroke(1.dp, Color.Gray), RoundedCornerShape(50))
                            .background(Colors.white)
                    ) {
                        Row(Modifier.padding(horizontal = 8.dp, vertical = 11.dp)) {
                            Text(
                                text = Localisation.Preferences.addTag.localised,
                                color = Color.Gray
                            )
                        }
                    }
                }
            }
        }
    }
}