package com.miam.sdk.components.myMeal.myMealRecipeCard

import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import com.miam.core.model.Recipe
import com.miam.core.viewModels.basketPreview.BasketPreviewContract
import com.miam.core.viewModels.basketPreview.BasketPreviewViewModel
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.myMeal.myMealRecipeCard.loading.MyMealRecipeCardLoadingParameters
import com.miam.sdk.components.myMeal.myMealRecipeCard.success.MyMealRecipeCardSuccessParameters
import com.miam.sdk.di.TemplateDI


@Composable
fun MyMealRecipeCard(
    recipe: Recipe,
    goToDetail: () -> Unit,
) {
    val vmBasketPreview by remember(recipe.id) { mutableStateOf(BasketPreviewViewModel(recipe.id)) }
    var isDeleting by remember(Boolean) { mutableStateOf(false) }
    val state by vmBasketPreview.uiState.collectAsState()

    DisposableEffect(Unit) { onDispose { vmBasketPreview.dispose() } }

    ManagementResourceState(
        resourceState = state.recipeInfo,
        successView = { recipeInfo ->
            requireNotNull(recipeInfo)

            TemplateDI.myMeal.recipeCard.success.view.Content(params =
            MyMealRecipeCardSuccessParameters(
                recipe = recipeInfo.recipe,
                totalPrice = state.recipePrice,
                guestCount = state.recipeGuest,
                numberOfProductsInRecipe = recipeInfo.foundEntriesCount,
                openRecipeDetail = goToDetail,
                isDeleting = isDeleting,
                delete = {
                    isDeleting = true
                    vmBasketPreview.setEvent(BasketPreviewContract.Event.RemoveRecipe(recipeInfo.recipe.id))
                }
            )
            )
        },
        loadingView = {
            TemplateDI.myMeal.recipeCard.loading.view.Content(params = MyMealRecipeCardLoadingParameters)
        }
    )
}

