package com.miam.sdk.components.mealPlanner.replaceRecipePage

import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.grid.GridCells
import androidx.compose.foundation.lazy.grid.GridItemSpan
import androidx.compose.foundation.lazy.grid.LazyVerticalGrid
import androidx.compose.foundation.lazy.grid.itemsIndexed
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.AbstractComposeView
import androidx.compose.ui.unit.dp
import androidx.compose.ui.zIndex
import com.miam.core.model.Recipe
import com.miam.core.viewModels.mealPlanner.replaceRecipePage.MealPlannerReplaceRecipePageViewModel
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.filter.Filter
import com.miam.sdk.components.mealPlanner.recipe.MealPlannerRecipeCard
import com.miam.sdk.components.mealPlanner.recipe.loading.Component
import com.miam.sdk.components.mealPlanner.recipe.loading.MealPlannerRecipeLoadingParameters
import com.miam.sdk.components.mealPlanner.search.MealPlannerSearchParameters
import com.miam.sdk.components.mealPlanner.search.empty.MealPlannerSearchEmptyParameters
import com.miam.sdk.di.TemplateDI

class MealPlannerReplaceRecipePage @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    var numberOfColumns: Int = 2
    private val mealPlannerReplaceRecipePageVM = MealPlannerReplaceRecipePageViewModel()

    private var goToBackToMeals = { }

    fun bind(goToBackToMeals: () -> Unit) {
        this.goToBackToMeals = goToBackToMeals
    }

    var index: Int = 0
        set(value) {
            field = value
        }

    @Composable
    override fun Content() {
        DisposableEffect(Unit) { onDispose { mealPlannerReplaceRecipePageVM.dispose() } }
        val state by mealPlannerReplaceRecipePageVM.uiState.collectAsState()
        var filterOpened by remember { mutableStateOf(false) }

        fun closeModal() {
            filterOpened = false
        }

        val filter = Filter("Meal Planner", ::closeModal, ::closeModal)

        Box() {
            if (filterOpened) {
                Box(
                    Modifier
                        .background(com.miam.kmm_miam_sdk.android.theme.Colors.white)
                        .fillMaxSize()
                        .zIndex(10f)
                ) {
                    filter.Content()
                }
            }
            Scaffold(
                backgroundColor = Color.Transparent,
                topBar = {
                    TemplateDI.mealPlanner.search.search.Content(
                        budgetSearchParameters =
                        MealPlannerSearchParameters(
                            updateSearch = { newSearchValue -> mealPlannerReplaceRecipePageVM.search(newSearchValue) },
                            filtersTapped = { filterOpened = true })
                    )

                }) {
                Box(modifier = Modifier.padding(it)) {

                    ManagementResourceState(
                        resourceState = state.recipes,
                        successView = { recipes ->
                            requireNotNull(recipes)
                            BudgetPlannerRecipePickerView(recipes = recipes, isFetching = state.isFetchingNewPage)
                        },
                        loadingView = {
                            LazyVerticalGrid(
                                columns = GridCells.Fixed(numberOfColumns),
                                contentPadding = PaddingValues(12.dp),
                                verticalArrangement = Arrangement.spacedBy(com.miam.kmm_miam_sdk.android.theme.Dimension.mPadding, Alignment.Top),
                                horizontalArrangement = Arrangement.spacedBy(com.miam.kmm_miam_sdk.android.theme.Dimension.mPadding, Alignment.Start)
                            ) {
                                items(4) { item ->
                                    TemplateDI.mealPlanner.recipeCard.loading.view.Content(
                                        MealPlannerRecipeLoadingParameters(Component.SEARCH_RESULT)
                                    )
                                }
                            }
                        },
                        emptyView = {
                            TemplateDI.mealPlanner.searchEmpty.view.Content(
                                mealPlannerSearchEmptyParameters = MealPlannerSearchEmptyParameters(
                                    "", false
                                )
                            )
                        }
                    )
                }
            }
        }
    }


    @Composable
    private fun BudgetPlannerRecipePickerView(recipes: List<Recipe>, isFetching: Boolean) {

        var isFetching by remember { mutableStateOf(isFetching) }

        Box(modifier = Modifier.fillMaxSize()) {
            LazyVerticalGrid(
                columns = GridCells.Fixed(numberOfColumns),
                contentPadding = PaddingValues(12.dp),
                verticalArrangement = Arrangement.spacedBy(com.miam.kmm_miam_sdk.android.theme.Dimension.mPadding, Alignment.Top),
                horizontalArrangement = Arrangement.spacedBy(com.miam.kmm_miam_sdk.android.theme.Dimension.mPadding, Alignment.Start)
            ) {
                itemsIndexed(recipes, { _, recipe -> recipe.id }) { i, item ->
                    val recipe = MealPlannerRecipeCard(context = context)
                    recipe.recipe = item
                    recipe.isInSearchPage = true
                    recipe.replaceAction = {
                        mealPlannerReplaceRecipePageVM.addRecipeToMealPlanner(item.id, index)
                        goToBackToMeals()
                    }
                    recipe.Content()
                    if (i == recipes.lastIndex) {
                        mealPlannerReplaceRecipePageVM.loadPage()
                    }
                }
                item(span = { GridItemSpan(numberOfColumns) }) {
                    if (isFetching) {
                        CircularProgressIndicator(color = com.miam.kmm_miam_sdk.android.theme.Colors.primary)
                    }
                }
            }
        }
    }
}