package com.miam.sdk.components.mealPlanner.recap.success

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Divider
import androidx.compose.material.Icon
import androidx.compose.material.Text
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.CheckCircle
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors.black
import com.miam.sdk.components.price.formatPrice

class MealPlannerRecapImp: MealPlannerRecap {

    //TODO  ADD TRANSLATION
    @Composable
    override fun Content(mealPlannerRecapParameters: MealPlannerRecapParameters) {
        Column(
            Modifier
                .fillMaxSize()
                .padding(horizontal = 16.dp),
            verticalArrangement = Arrangement.Top,
            horizontalAlignment = Alignment.CenterHorizontally

        ) {
            Spacer(modifier = Modifier.height(24.dp))
            Row(
                Modifier
                    .background(color = com.miam.kmm_miam_sdk.android.theme.Colors.miamSuccessBackGround, shape = RoundedCornerShape(8.dp))
                    .fillMaxWidth(),
                horizontalArrangement = Arrangement.Center,
                verticalAlignment = Alignment.CenterVertically
            ) {
                Icon(
                    Icons.Default.CheckCircle,
                    contentDescription = "",
                    tint = com.miam.kmm_miam_sdk.android.theme.Colors.positive,
                    modifier = Modifier
                        .padding(20.dp)
                        .size(20.dp)
                )
            }
            Spacer(modifier = Modifier.height(24.dp))
            Text(
                text = Localisation.Budget.mealPlannerProductAdded.localised,
                modifier = Modifier.fillMaxWidth(),
                style = com.miam.kmm_miam_sdk.android.theme.Typography.subtitleBold,
                textAlign = TextAlign.Center,
                color = black
            )
            Spacer(modifier = Modifier.height(24.dp))
            Row(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.SpaceBetween,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(8.dp)
                    .border(
                        BorderStroke(1.dp, com.miam.kmm_miam_sdk.android.theme.Colors.grey),
                        shape = RoundedCornerShape(8.dp)
                    )
            ) {
                Text(
                    text = Localisation.Budget.mealPlannerMealsFor(mealPlannerRecapParameters.numberOfMeals).localised,
                    style = com.miam.kmm_miam_sdk.android.theme.Typography.body,
                    modifier = Modifier.padding(8.dp)
                )
                Text(
                    text = mealPlannerRecapParameters.totalPrice.formatPrice(),
                    style = com.miam.kmm_miam_sdk.android.theme.Typography.subtitleBold,
                    color = com.miam.kmm_miam_sdk.android.theme.Colors.primary,
                    modifier = Modifier.padding(8.dp)
                )
            }
            Spacer(modifier = Modifier.height(24.dp))
            Divider()
            Spacer(modifier = Modifier.height(24.dp))
            Text(
                text = Localisation.Budget.mealPlannerDiscover.localised,
                modifier = Modifier.fillMaxWidth(),
                style = com.miam.kmm_miam_sdk.android.theme.Typography.subtitleBold,
                textAlign = TextAlign.Center,
                color = black
            )
            Spacer(modifier = Modifier.height(24.dp))
            Box(
                Modifier
                    .background(color = com.miam.kmm_miam_sdk.android.theme.Colors.primary, shape = RoundedCornerShape(8.dp))
                    .padding(8.dp)
                    .fillMaxWidth()
                    .clickable {
                        mealPlannerRecapParameters.action()
                    }
            ) {
                Text(
                    text = Localisation.Budget.mealPlannerPromotion.localised,
                    modifier = Modifier
                        .padding(8.dp)
                        .fillMaxWidth(),
                    color = com.miam.kmm_miam_sdk.android.theme.Colors.white,
                    style = com.miam.kmm_miam_sdk.android.theme.Typography.bodyBold,
                    textAlign = TextAlign.Center
                )
            }
        }
    }
}