package com.miam.sdk.components.itemSelector.header


import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.material.IconButton
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.sp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image

import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Dimension.xlButtonHeight

class ItemSelectorHeaderImp: ItemSelectorHeader {
    @Composable
    override fun Content(params: ItemSelectorHeaderParameters) {
        Box(modifier = Modifier.fillMaxWidth()) {
            IconButton(
                modifier = Modifier.size(xlButtonHeight).align(Alignment.CenterStart),
                onClick = params.previous
            ) {
                Image(
                    colorFilter = ColorFilter.tint(Colors.primary),
                    painter = painterResource(Image.toggleCaret),
                    contentDescription = "Previous",
                    modifier = Modifier.rotate(180f)
                )
            }
            Text(
                text = Localisation.ItemSelector.headerTitle.localised,
                modifier = Modifier.fillMaxWidth().align(Alignment.Center),
                textAlign = TextAlign.Center,
                style = TextStyle(fontSize = 16.sp, fontWeight = FontWeight.Bold)
            )
        }
    }
}