package com.miam.sdk.components.baseComponent.likeButton.loading

import androidx.compose.animation.Crossfade
import androidx.compose.animation.core.tween
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors

class LikeButtonLoadingImp: LikeButtonLoading {
    @Composable
    override fun Content() {
        val isLiked = false
        Surface(shape = CircleShape) {
            Box(
                Modifier
                    .background(Colors.white)
                    .padding(8.dp)
            ) {
                Crossfade(targetState = isLiked, animationSpec = tween(750, 0), label = "Fading 750ms") { currentIsLiked ->
                    if (currentIsLiked) {
                        Image(
                            painter = painterResource(Image.favoriteFilled),
                            contentDescription = "favorite filled",
                            modifier = Modifier.size(20.dp)
                                .padding(start = 2.dp),
                        )
                    } else {
                        Image(
                            painter = painterResource(Image.favorite),
                            contentDescription = "favorite unfilled",
                            modifier = Modifier.size(20.dp)
                                .padding(start = 2.dp),
                        )
                    }
                }
            }
        }
    }
}