package com.miam.sdk.components.tag

import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.model.Recipe
import com.miam.core.viewModels.basketTag.BasketTagContract
import com.miam.core.viewModels.basketTag.BasketTagViewModel
import com.miam.kmm_miam_sdk.android.ui.components.routerOutlet.RouterOutlet
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.tag.success.BasketTagSuccessParameters
import com.miam.sdk.di.TemplateDI

class BasketTag @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private val fullscreen = RouterOutlet()
    private val vmTag = BasketTagViewModel(fullscreen.getViewModel())

    private fun goToDetail(recipe: Recipe) {
        vmTag.goToDetail(recipe)
    }

    /**
     * Don't delete use by client
     */
    fun bind(retailerProductId: String) {
        vmTag.setEvent(BasketTagContract.Event.SetRetailerProductId(retailerProductId))
    }

    @Composable
    override fun Content() {
        val state by vmTag.uiState.collectAsState()
        Column {
            // Empty at init
            fullscreen.Content()
            ManagementResourceState(
                resourceState = state.recipeList,
                successView = { recipes ->
                    requireNotNull(recipes)
                    TemplateDI.basketTag.success.view.Content(
                        param = BasketTagSuccessParameters(
                            recipes = recipes,
                            goToDetails = ::goToDetail
                        )
                    )
                },
                loadingView = {
                    TemplateDI.basketTag.loading.view.Content()
                },
                emptyView = {
                    TemplateDI.basketTag.empty.view.Content()
                }
            )
        }
    }
}