package com.miam.sdk.components.recipeDetail.success.unavailable

import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import com.miam.core.localisation.Localisation
import com.miam.core.viewModels.product.ProductViewModel
import com.miam.sdk.components.recipeDetail.success.oftenDeleted.header.UnavailableProductsHeaderParameters
import com.miam.sdk.components.recipeDetail.success.unavailable.unavailableProduct.ProductUnavailableParameters
import com.miam.sdk.di.TemplateDI
import kotlinx.coroutines.flow.MutableStateFlow

@Composable
fun UnavailableProducts(productsVm: MutableStateFlow<List<ProductViewModel>>, guestsCount: MutableStateFlow<Int>, defaultRecipeGuest: Int) {

    val productsVmState by productsVm.collectAsState()
    var isOpen by remember { mutableStateOf(false) }

    fun toggle() {
        isOpen = !isOpen
    }
    if (productsVmState.isNotEmpty()) {
        TemplateDI.recipeDetail.success.unavailable.header.view.Content(
            UnavailableProductsHeaderParameters(
                title = Localisation.RecipeDetails.unavailable.localised,
                isOpen = isOpen,
                toggle = ::toggle
            )
        )
        if (isOpen) {
            productsVmState.forEach { productVm ->
                val productState by productVm.uiState.collectAsState()
                productState.ingredient?.let { ingredient ->
                    TemplateDI.recipeDetail.success.unavailable.product.view.Content(
                        params = ProductUnavailableParameters(
                            ingredient.name,
                            ingredient.attributes?.quantity ?: "Attribute no found",
                            ingredient.attributes?.unit ?: "Attribute no found",
                            guestsCount = guestsCount,
                            defaultRecipeGuest = defaultRecipeGuest
                        )
                    )
                }
            }
        }
    }
}