package com.miam.sdk.components.recipeCard

import com.miam.sdk.components.recipeCard.empty.RecipeCardEmptyConfig
import com.miam.sdk.components.recipeCard.empty.RecipeCardEmptyConfigBuilder
import com.miam.sdk.components.recipeCard.loading.RecipeCardLoadingConfig
import com.miam.sdk.components.recipeCard.loading.RecipeCardLoadingConfigBuilder
import com.miam.sdk.components.recipeCard.success.RecipeCardSuccessConfig
import com.miam.sdk.components.recipeCard.success.RecipeCardSuccessConfigBuilder

class RecipeCardConfigBuilder {
    var success: RecipeCardSuccessConfig = RecipeCardSuccessConfig()
    var empty: RecipeCardEmptyConfig = RecipeCardEmptyConfig()
    var loading: RecipeCardLoadingConfig = RecipeCardLoadingConfig()

    inline fun success(init: RecipeCardSuccessConfigBuilder.() -> Unit) {
        this.success = RecipeCardSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: RecipeCardEmptyConfigBuilder.() -> Unit) {
        this.empty = RecipeCardEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: RecipeCardLoadingConfigBuilder.() -> Unit) {
        this.loading = RecipeCardLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): RecipeCardConfig {
        return RecipeCardConfig(success, empty, loading)
    }
}