package com.miam.sdk.components.catalog.success.toolbar

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.offset
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.core.viewModels.catalog.CatalogContent
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.sdk.di.TemplateDI

class CatalogSuccessToolbarImp: CatalogSuccessToolbar {
    @Composable
    override fun Content(params: CatalogSuccessToolbarParameters) {
        Column(Modifier.background(color = Colors.primary)) {
            if (params.content == CatalogContent.CATEGORIES_LIST) {
                Box(Modifier.fillMaxWidth()) {
                    Row(Modifier.padding(16.dp)) {
                        Image(
                            painter = painterResource(Image.recipeIdea),
                            contentDescription = null,
                            colorFilter = ColorFilter.tint(Colors.white),
                            modifier = Modifier.padding(end = 8.dp)
                        )
                        Box {
                            Text(
                                text = Localisation.Catalog.title.localised,
                                color = Colors.white,
                                style = Typography.subtitleBold,
                                modifier = Modifier.align(Alignment.Center)
                            )
                            Image(
                                painter = painterResource(Image.trait),
                                contentDescription = null,
                                Modifier
                                    .align(Alignment.BottomEnd)
                                    .offset(y = 4.dp)
                            )
                        }
                    }
                }
            }
            Row(
                Modifier
                    .fillMaxWidth()
                    .padding(12.dp),
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = if (params.content == CatalogContent.CATEGORIES_LIST) Arrangement.Start else Arrangement.SpaceBetween
            ) {
                if (params.content != CatalogContent.CATEGORIES_LIST) {
                    Clickable(onClick = { params.goToBack() }) {
                        Image(
                            painter = painterResource(Image.toggleCaret),
                            contentDescription = null,
                            colorFilter = ColorFilter.tint(Colors.white),
                            modifier = Modifier
                                .rotate(180f)
                                .padding(vertical = 8.dp)
                        )
                    }
                }
                Row {
                    Clickable(onClick = { params.openSearch() }) {
                        Surface(
                            shape = CircleShape,
                            elevation = 8.dp,
                            modifier = Modifier.padding(horizontal = 10.dp)
                        ) {
                            Box(
                                Modifier
                                    .background(Colors.white)
                                    .padding(8.dp)
                            )
                            {
                                Image(
                                    painter = painterResource(Image.search),
                                    contentDescription = null,
                                    colorFilter = ColorFilter.tint(Colors.primary),
                                )
                            }
                        }
                    }
                    if (TemplateDI.catalog.success.toolbar.enablePreferences) {
                        Clickable(onClick = { params.openPreferences() }) {
                            Surface(
                                shape = CircleShape,
                                elevation = 8.dp,
                                modifier = Modifier.padding(horizontal = 10.dp)
                            ) {
                                Box(
                                    Modifier
                                        .background(Colors.white)
                                        .padding(8.dp)
                                )
                                {
                                    Image(
                                        painter = painterResource(Image.guests),
                                        contentDescription = null,
                                        colorFilter = ColorFilter.tint(Colors.primary),
                                    )
                                }
                            }
                        }
                    }
                    if (TemplateDI.catalog.success.toolbar.enableFilters) {
                        Clickable(onClick = { params.openFilter() }) {
                            Box {
                                Surface(
                                    shape = CircleShape,
                                    elevation = 8.dp,
                                    modifier = Modifier.padding(horizontal = 10.dp)
                                ) {
                                    Row(
                                        Modifier
                                            .background(Colors.white)
                                            .padding(8.dp)
                                    )
                                    {
                                        Image(
                                            painter = painterResource(Image.filter),
                                            contentDescription = null,
                                            colorFilter = ColorFilter.tint(Colors.primary),
                                        )
                                    }
                                }
                                if (params.getActiveFilterCount() != 0) {
                                    Box(
                                        modifier = Modifier
                                            .size(20.dp)
                                            .clip(CircleShape)
                                            .background(Color.Red)
                                            .align(Alignment.TopEnd)
                                    ) {
                                        Text(
                                            text = params.getActiveFilterCount().toString(),
                                            color = Colors.white,
                                            modifier = Modifier.align(Alignment.Center)
                                        )
                                    }
                                }
                            }
                        }
                        if (params.content == CatalogContent.CATEGORIES_LIST) { //REPLACE IF BT WHEN ?
                            Box(modifier = Modifier
                                .padding(horizontal = 10.dp)
                                .border(
                                    border = BorderStroke(1.dp, Colors.white),
                                    shape = RoundedCornerShape(50)
                                )
                                .clickable { params.goToFavorite() }
                            ) {
                                Row(
                                    Modifier
                                        .padding(horizontal = 16.dp, vertical = 8.dp)
                                        .background(Colors.primary),
                                    verticalAlignment = Alignment.CenterVertically
                                ) {
                                    Image(
                                        painter = painterResource(Image.favorite),
                                        contentDescription = null,
                                        colorFilter = ColorFilter.tint(Colors.white),
                                        modifier = Modifier.padding(end = 8.dp)
                                    )
                                    Text(
                                        text = Localisation.Catalog.favoriteTitle.localised,
                                        color = Colors.white
                                    )
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}