package com.miam.sdk.components.baseComponent.recipesPage

import android.content.Context
import android.util.AttributeSet
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.handler.LogHandler
import com.miam.core.viewModels.defaultViewModel.recipesPageViewModel.RecipesPageViewModel
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageParameters
import com.miam.sdk.components.baseComponent.loader.LoaderParameters
import com.miam.sdk.components.baseComponent.recipesPage.success.RecipesPageSuccess
import com.miam.sdk.di.TemplateDI
import kotlinx.coroutines.cancel

open class RecipesPage @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private val recipePageVM = RecipesPageViewModel()
    private var title = ""
    private var subtitle = ""
    private var back: () -> Unit = { LogHandler.error("[Miam][Error] you must bind back function") }
    private var emptyTitle = ""
    private var emptySubtitle = ""

    fun bind(
        title: String,
        back: () -> Unit,
        emptyTitle: String,
        emptySubtitle: String,
        subtitle: String? = null,
    ) {
        this.title = title
        this.subtitle = subtitle ?: ""
        this.back = back
        this.emptyTitle = emptyTitle
        this.emptySubtitle = emptySubtitle
        subtitle?.let { this.subtitle = it }
    }

    @Composable
    override fun Content() {
        val state = recipePageVM.uiState.collectAsState()
        DisposableEffect(Unit) { onDispose { recipePageVM.cancel() } }
        ManagementResourceState(
            resourceState = state.value.recipes,
            successView = { recipes ->
                requireNotNull(recipes)
                RecipesPageSuccess(title,subtitle, recipes, recipePageVM.currentState.isFetchingNewPage) {
                    recipePageVM.loadPage()
                }
            },
            emptyView = {
                val params = EmptyPageParameters(title = emptyTitle, subtitle = emptySubtitle)
                TemplateDI.recipesPage.empty?.view?.Content(params = params)
                    ?: TemplateDI.defaultViews.empty.view.Content(params = params)
            },
            loadingView = {
                TemplateDI.recipesPage.loading?.view?.Content(params = LoaderParameters)
                    ?: TemplateDI.defaultViews.loading.view.Content(LoaderParameters)
            }
        )
    }
}

