package com.miam.sdk.components.baseComponent.myMealButton

import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.handler.LogHandler
import com.miam.core.viewModels.myMealButton.MyMealButtonViewModel
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.myMealButton.success.MyMealButtonSuccessParameters
import com.miam.sdk.di.TemplateDI

class MyMealButton @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private var onclick: () -> Unit = {
        LogHandler.error("[Miam][Error] You must init onclick on My meal button")
    }

    fun bind(onclick: () -> Unit) {
        this.onclick = onclick
    }

    private val myMealButtonVM: MyMealButtonViewModel = MyMealButtonViewModel()

    @Composable
    override fun Content() {
        DisposableEffect(Unit) { onDispose { myMealButtonVM.dispose() } }
        val state by myMealButtonVM.uiState.collectAsState()

        ManagementResourceState(
            resourceState = state.recipeCount,
            successView = { recipeCount ->
                requireNotNull(recipeCount)
                TemplateDI.myMealButton.success.view.Content(params = MyMealButtonSuccessParameters(recipeCount, onclick))
            },
            loadingView = {
                Box {}
            },
            emptyView = {
                TemplateDI.myMealButton.empty.view.Content()
            }
        )
    }
}