package com.miam.sdk.components.mealPlanner.form.success

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.CircularProgressIndicator
import androidx.compose.material.Icon
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.zIndex
import com.miam.core.base.state.ComponentUiState
import com.miam.core.localisation.Localisation
import com.miam.sdk.components.mealPlanner.meals.toolbar.MealPlannerBudget


internal class MealPlannerFormSuccessImp: MealPlannerFormSuccess {
    @Composable
    override fun Content(params: MealPlannerFormSuccessParameters) {

        Column(
            modifier = Modifier
                .padding(com.miam.kmm_miam_sdk.android.theme.Dimension.lPadding)
                .background(com.miam.kmm_miam_sdk.android.theme.Colors.white)
                .zIndex(1f)
        ) {
            MealPlannerBudget(
                modifier = Modifier.fillMaxWidth(),
                caption = Localisation.Budget.totalBudgetTitle.localised,
                currency = Localisation.Price.currency.localised,
                budget = params.budget,
                onBudgetChange = {
                    params.setBudget(it)
                })

            Spacer(modifier = Modifier.height(com.miam.kmm_miam_sdk.android.theme.Dimension.lSpacerHeight))

            Row(
                Modifier
                    .fillMaxWidth()
            ) {
                Box(modifier = Modifier.weight(1f)) {
                    MealPlannerCounter(
                        caption = Localisation.Budget.numberOfGuestsTitle.localised,
                        initialCount = params.numberOfGuests,
                        onCounterChanged = { params.setNumberOfGuests(it) })
                }
                Spacer(modifier = Modifier.width(com.miam.kmm_miam_sdk.android.theme.Dimension.sSpacerHeight))
                Box(modifier = Modifier.weight(1f)) {
                    MealPlannerCounter(
                        caption = Localisation.Budget.numberOfMealsTitle.localised,
                        initialCount = params.numberOfMeals,
                        onCounterChanged = { params.setNumberOfMeals(it) })
                }
            }

            Spacer(modifier = Modifier.height(com.miam.kmm_miam_sdk.android.theme.Dimension.lSpacerHeight))

            Button(
                modifier = Modifier
                    .fillMaxWidth()
                    .height(48.dp),
                onClick = {
                    params.submit(
                        params.budget,
                        params.numberOfMeals,
                        params.numberOfGuests
                    )
                },
                shape = RoundedCornerShape(6.dp),
                colors = ButtonDefaults.buttonColors(backgroundColor = com.miam.kmm_miam_sdk.android.theme.Colors.primary),
                enabled = params.budget.toString()
                    .isNotEmpty() && params.uiState != ComponentUiState.EMPTY
            ) {
                Box(modifier = Modifier.fillMaxHeight(), contentAlignment = Alignment.Center) {
                    if (params.uiState == ComponentUiState.LOADING) {
                        CircularProgressIndicator(
                            modifier = Modifier.size(com.miam.kmm_miam_sdk.android.theme.Dimension.lIconHeight),
                            strokeWidth = 2.dp,
                            color = com.miam.kmm_miam_sdk.android.theme.Colors.white
                        )
                    } else {
                        Text(text = Localisation.Budget.planMealsTitle.localised, color = com.miam.kmm_miam_sdk.android.theme.Colors.white)
                    }
                }
            }
            Spacer(modifier = Modifier.height(32.dp))
            AnimatedVisibility(params.uiState == ComponentUiState.EMPTY) {
                Box(modifier = Modifier.background(com.miam.kmm_miam_sdk.android.theme.Colors.miamDangerBackground, RoundedCornerShape(8.dp))) {
                    Column(
                        Modifier.padding(16.dp)
                    ) {
                        Icon(
                            painter = painterResource(id = com.miam.kmm_miam_sdk.android.ressource.Image.alert),
                            contentDescription = "",
                            tint = com.miam.kmm_miam_sdk.android.theme.Colors.dangerBudgetText
                        )
                        Spacer(modifier = Modifier.height(8.dp))
                        Text(
                            text = Localisation.Budget.noResultsForBudget.localised,
                            color = com.miam.kmm_miam_sdk.android.theme.Colors.dangerBudgetText
                        )
                    }
                }
            }
        }
    }
}
