package com.miam.sdk.components.mealPlanner.basketPreview.success.notInBasket.header

import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.IconButton
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.ressource.Image.toggleCaret

class NotInBasketProductHeaderImp: NotInBasketProductHeader {
    @Composable
    override fun Content(params: NotInBasketProductHeaderParameters) {

        val rotationState by animateFloatAsState(
            targetValue = if (params.isExpanded) 90f else 0f, label = "Icon rotation state "
        )

        Row(
            verticalAlignment = Alignment.CenterVertically,
            modifier = Modifier
                .fillMaxWidth()
                .padding(start = 16.dp)
        ) {
            Text(
                text = params.title,
                modifier = Modifier.weight(6f),
                maxLines = 1,
                fontWeight = if (params.isExpanded) FontWeight.Bold else FontWeight.Normal
            )
            IconButton(modifier = Modifier
                .weight(1f)
                .rotate(rotationState), onClick = { params.toggle() }) {
                Image(
                    painter = painterResource(toggleCaret),
                    contentDescription = "open icon",
                    modifier = Modifier
                )
            }
        }
    }
}