package com.miam.sdk.components.catalog.success.search

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.foundation.text.KeyboardActions
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.material.TextField
import androidx.compose.material.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester
import androidx.compose.ui.focus.onFocusChanged
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.input.ImeAction
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable

internal class CatalogSuccessSearchImp: CatalogSuccessSearch {
    @Composable
    override fun Content(params: CatalogSuccessSearchParameters) {

        val textState = remember { mutableStateOf("") }
        Box(
            Modifier
                .fillMaxSize()
                .background(Colors.white)
        ) {
            Column(modifier = Modifier.padding(horizontal = 10.dp)) {
                BackButton(params.onClose)
                SearchContainer {
                    val focusRequester = FocusRequester()
                    TextField(
                        modifier = Modifier
                            .focusRequester(focusRequester)
                            .onFocusChanged {
                                textState.value = ""
                            },
                        singleLine = true,
                        value = textState.value,
                        onValueChange = { textState.value = it },
                        colors = TextFieldDefaults.textFieldColors(
                            disabledTextColor = Color.Transparent,
                            backgroundColor = Color.White,
                            focusedIndicatorColor = Color.Transparent,
                            unfocusedIndicatorColor = Color.Transparent,
                            disabledIndicatorColor = Color.Transparent
                        ),
                        placeholder = { Text(Localisation.Catalog.searchPlaceholder.localised) },
                        keyboardOptions = KeyboardOptions.Default.copy(
                            imeAction = ImeAction.Search
                        ),
                        keyboardActions = KeyboardActions(
                            onSearch = {
                                params.updateSearch(textState.value)
                                params.onApply()
                            }
                        ),
                    )
                    SearchButton(textState, params.updateSearch, params.onApply)
                }
            }
        }

    }

    @Composable
    fun BackButton(close: () -> Unit) {
        Row(Modifier.fillMaxWidth()) {
            Clickable(onClick = close) {
                Image(
                    painter = painterResource(Image.toggleCaret),
                    contentDescription = "Back button",
                    Modifier
                        .rotate(180f)
                        .padding(vertical = 8.dp)
                )
            }
        }
    }

    @Composable
    fun SearchContainer(children: @Composable () -> Unit) {
        Row(
            Modifier
                .fillMaxWidth()
                .border(border = BorderStroke(1.dp, Colors.primary), shape = RoundedCornerShape(50)),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween
        ) {
            children()
        }
    }

    @Composable
    fun SearchButton(textState: MutableState<String>, updateResearch: (String) -> Unit, apply: () -> Unit) {
        Clickable(onClick = {
            updateResearch(textState.value)
            apply()
        }) {
            Surface(shape = CircleShape, elevation = 8.dp, modifier = Modifier.padding(horizontal = 10.dp)) {
                Box(
                    Modifier
                        .background(Colors.primary)
                        .padding(8.dp)
                )
                {
                    Image(painter = painterResource(Image.search), contentDescription = "Search button", colorFilter = ColorFilter.tint(Colors.white))
                }
            }
        }
    }
}