package com.miam.sdk.components.catalog.success.categoriesPage

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.runtime.Composable
import androidx.compose.runtime.key
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.core.model.Package
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageParameters
import com.miam.sdk.components.catalog.success.categoriesPage.category.CatalogCategoriesPageCategoryParameters
import com.miam.sdk.components.mealPlanner.callToAction.success.MealPlannerCallToActionSuccessParameters
import com.miam.sdk.di.TemplateDI

@Composable
fun CatalogCategoriesPage(
    categories: List<Package>,
    goToCategoryPage: (id: String, title: String, subtitle: String?) -> Unit,
    goToMealPlanner: (() -> Unit)? = null
) {
    Box(
        Modifier
            .fillMaxSize()
    ) {
        if (categories.isNotEmpty()) {
            LazyColumn {
                goToMealPlanner?.let {
                    item {
                        Row(
                            Modifier
                                .padding(vertical = 8.dp)
                                .fillMaxWidth(),
                            horizontalArrangement = Arrangement.Center
                        ) {
                            TemplateDI.mealPlannerCallToAction.success.view.Content(
                                params = MealPlannerCallToActionSuccessParameters {
                                    goToMealPlanner()
                                })
                        }
                    }
                }
                items(items = categories) { category ->
                    key(category.id) {
                        TemplateDI.catalog.success.categories.category.view.Content(param = CatalogCategoriesPageCategoryParameters(
                            category,
                            category.relationships?.recipes?.data?.map { it.id } ?: emptyList(),
                        ) {
                            goToCategoryPage(
                                it.id,
                                it.attributes?.title ?: "",
                                it.attributes?.settings?.subtitle
                            )
                        })
                    }
                }
            }
        } else {
            val params = EmptyPageParameters(Localisation.Catalog.preferencesNoResult.localised)
            TemplateDI.catalog.empty?.view?.Content(params = params)
                ?: TemplateDI.defaultViews.empty.view.Content(params = params)
        }
    }
}
