package com.miam.sdk.components.tag.success

import androidx.compose.foundation.Image
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Card
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import com.miam.core.localisation.Localisation
import com.miam.core.model.Recipe
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography

class BasketTagSuccessImp: BasketTagSuccess {
    @Composable
    override fun Content(param: BasketTagSuccessParameters) {
        val openRecipeLinkDialog = remember { mutableStateOf(false) }
        Row(
            verticalAlignment = Alignment.CenterVertically
        ) {
            if (openRecipeLinkDialog.value) {
                AllRecipeLinkDialog(openRecipeLinkDialog, param.recipes, param.goToDetails)
            }
            Box(
                modifier = Modifier.clickable { param.goToDetails(param.recipes[0]) }
            ) {
                param.recipes[0].attributes?.let {
                    Text(
                        text = it.title,
                        Modifier
                            .border(
                                width = 1.dp,
                                color = Colors.grey,
                                shape = RoundedCornerShape(16.dp)
                            )
                            .padding(
                                horizontal = 8.dp, vertical = 2.dp
                            ),
                        color = Colors.grey
                    )
                }
            }
            Spacer(modifier = Modifier.padding(horizontal = 4.dp))
            if (param.recipes.size > 1) {
                Box(
                    Modifier
                        .border(1.dp, Colors.primary, CircleShape)
                        .padding(horizontal = 4.dp, vertical = 2.dp)
                        .clickable { openRecipeLinkDialog.value = true }
                ) {
                    Text(
                        text = "+ ${(param.recipes.size - 1)}",
                        color = Colors.primary,
                        style = Typography.overLine,
                        modifier = Modifier.align(Alignment.Center)
                    )
                }
            }
        }
    }
}

@Composable
private fun AllRecipeLinkDialog(
    openRecipeLinkDialog: MutableState<Boolean>,
    recipes: List<Recipe>,
    goToDetails: (recipe: Recipe) -> Unit
) {
    Dialog(
        onDismissRequest = {
            openRecipeLinkDialog.value = false
        }
    ) {
        Card {
            Column(Modifier.padding(16.dp)) {
                Text(
                    text = "${Localisation.Tag.preRecipeCount.localised} ${recipes.size} ${Localisation.Tag.postRecipeCount.localised}",
                    style = Typography.bodyBold,
                    modifier = Modifier.padding(bottom = 16.dp)
                )
                for (recipe in recipes) {
                    recipe.attributes?.let {
                        Text(
                            text = it.title,
                            style = Typography.link.copy(textDecoration = TextDecoration.Underline),
                            color = Colors.primary,
                            modifier = Modifier
                                .padding(bottom = 16.dp)
                                .clickable {
                                    goToDetails(recipe)
                                    openRecipeLinkDialog.value = false
                                }
                        )
                    }
                }
                Divider()
                Box(
                    Modifier
                        .fillMaxWidth()
                        .clickable { openRecipeLinkDialog.value = false }
                ) {
                    Image(
                        painter = painterResource(Image.close),
                        contentDescription = "close button",
                        modifier = Modifier.align(Alignment.Center)
                    )
                }
            }
        }
    }
}