package com.miam.sdk.components.tag

import com.miam.sdk.components.tag.empty.BasketTagEmptyConfig
import com.miam.sdk.components.tag.empty.BasketTagEmptyConfigBuilder
import com.miam.sdk.components.tag.loading.BasketTagLoadingConfig
import com.miam.sdk.components.tag.loading.BasketTagLoadingConfigBuilder
import com.miam.sdk.components.tag.success.BasketTagSuccessConfig
import com.miam.sdk.components.tag.success.BasketTagSuccessConfigBuilder

class BasketTagConfigBuilder {
    var success: BasketTagSuccessConfig = BasketTagSuccessConfig()
    var empty: BasketTagEmptyConfig = BasketTagEmptyConfig()
    var loading: BasketTagLoadingConfig = BasketTagLoadingConfig()

    inline fun success(init: BasketTagSuccessConfigBuilder.() -> Unit) {
        success = BasketTagSuccessConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun empty(init: BasketTagEmptyConfigBuilder.() -> Unit) {
        empty = BasketTagEmptyConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loading(init: BasketTagLoadingConfigBuilder.() -> Unit) {
        loading = BasketTagLoadingConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): BasketTagConfig {
        return BasketTagConfig(success, empty, loading)
    }
}