package com.miam.sdk.components.recipeCarousel.loader

import androidx.compose.foundation.horizontalScroll
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.rememberScrollState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.sdk.di.TemplateDI

class RecipeCarouselLoaderImp: RecipeCarouselLoader {
    @Composable
    override fun Content(params: RecipeCarouselLoaderParameters) {
        val scrollState = rememberScrollState()

        Row(modifier = Modifier.horizontalScroll(scrollState)) {
            for (i in 1..params.numberOfRecipe) {
                Box(
                    modifier = Modifier
                        .width(350.dp)
                        .height(380.dp)
                ) {
                    TemplateDI.recipeCard.loading.view.Content()
                }
            }
        }
    }
}