package com.miam.sdk.components.price

import com.miam.sdk.components.price.empty.EmptyPriceConfig
import com.miam.sdk.components.price.empty.EmptyPriceConfigBuilder
import com.miam.sdk.components.price.footer.FooterPriceConfig
import com.miam.sdk.components.price.footer.FooterPriceConfigBuilder
import com.miam.sdk.components.price.loading.LoadingPriceConfig
import com.miam.sdk.components.price.loading.LoadingPriceConfigBuilder
import com.miam.sdk.components.price.recipePrice.RecipePriceConfig
import com.miam.sdk.components.price.recipePrice.RecipePriceConfigBuilder
import com.miam.sdk.components.price.productPrice.ProductPriceConfig
import com.miam.sdk.components.price.productPrice.ProductPriceConfigBuilder

class PriceConfigBuilder {
    var productPrice : ProductPriceConfig = ProductPriceConfig()
    var recipePrice : RecipePriceConfig = RecipePriceConfig()
    var loadingPrice : LoadingPriceConfig = LoadingPriceConfig()
    var emptyPrice : EmptyPriceConfig = EmptyPriceConfig()
    var footerPrice : FooterPriceConfig = FooterPriceConfig()

    inline fun productPrice(init: ProductPriceConfigBuilder.() -> Unit) {
        productPrice = ProductPriceConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun recipePrice(init: RecipePriceConfigBuilder.() -> Unit) {
        recipePrice = RecipePriceConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun loadingPrice(init: LoadingPriceConfigBuilder.() -> Unit) {
        loadingPrice = LoadingPriceConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun emptyPrice(init: EmptyPriceConfigBuilder.() -> Unit) {
        emptyPrice = EmptyPriceConfigBuilder()
            .apply(init)
            .build()
    }

    inline fun footerPrice(init: FooterPriceConfigBuilder.() -> Unit) {
        footerPrice = FooterPriceConfigBuilder()
            .apply(init)
            .build()
    }

    @PublishedApi
    internal fun build(): PriceConfig {
        return PriceConfig(productPrice, recipePrice, loadingPrice, emptyPrice, footerPrice)
    }
}