package com.miam.sdk.components.preferences.success.header

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable


class PreferencesSuccessHeaderImp: PreferencesSuccessHeader {
    @Composable
    override fun Content(params: PreferencesSuccessHeaderParameters) {
        Column {
            Row(
                modifier = Modifier
                    .fillMaxWidth()
                    .height(60.dp),
                verticalAlignment = Alignment.CenterVertically
            ) {
                Clickable(onClick = { params.close() }) {
                    Box(
                        Modifier
                            .padding(12.dp)
                            .clip(CircleShape)
                            .background(Colors.backgroundGrey)
                    ) {
                        Image(
                            painter = painterResource(Image.close),
                            contentDescription = null,
                        )
                    }
                }
                Spacer(modifier = Modifier.width(16.dp))
                Text(text = Localisation.Preferences.title.localised, style = Typography.subtitle.copy(fontWeight = FontWeight.Bold))
            }
            Divider(Modifier.fillMaxWidth())
        }
    }
}