package com.miam.sdk.components.preferences.success.equipmentSection

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Divider
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable
import com.miam.kmm_miam_sdk.android.ui.components.common.RoundedCheckbox

class PreferencesEquipmentSectionImp: PreferencesEquipmentSection {
    @Composable
    override fun Content(params: PreferencesEquipmentSectionParameters) {
        Column {
            Text(
                text = Localisation.Preferences.cookingEquipmentTitle.localised,
                style = Typography.bodyBold,
                modifier = Modifier.padding(bottom = 4.dp)
            )
            Text(text = Localisation.Preferences.cookingEquipmentSubtitle.localised, style = Typography.bodySmall)
            Spacer(modifier = Modifier.height(16.dp))
            Column(Modifier.background(color = Colors.white, shape = RoundedCornerShape(topStart = 25.dp, topEnd = 25.dp))) {
                for (equipmentTag in params.equipmentsTag) {
                    Clickable(onClick = { params.togglePreference(equipmentTag.tag.id) }) {
                        Column {
                            Row(Modifier.padding(vertical = 14.dp, horizontal = 18.dp)) {
                                RoundedCheckbox(check = equipmentTag.isChecked) {
                                    params.togglePreference(equipmentTag.tag.id)
                                }
                                equipmentTag.tag.attributes?.name?.let {
                                    Text(
                                        text = it,
                                        style = Typography.body,
                                        modifier = Modifier.padding(start = 20.dp)
                                    )
                                }
                            }
                            Divider()
                        }
                    }
                }
            }
        }
    }
}