package com.miam.sdk.components.preferences.search.success.resultRow

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.miam.kmm_miam_sdk.android.theme.Typography
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable

class PreferencesSearchResultRowImp: PreferencesSearchResultRow {
    @Composable
    override fun Content(param: PreferencesSearchResultRowParameters) {
        Clickable(onClick = { param.select() }) {
            Row(
                Modifier
                    .fillMaxWidth()
                    .padding(horizontal = 16.dp)
            ) {
                Text(
                    text = param.name,
                    style = Typography.body,
                    modifier = Modifier.padding(vertical = 16.dp)
                )
            }
        }
    }
}