package com.miam.sdk.components.preferences.search.field

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.Image
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Text
import androidx.compose.material.TextField
import androidx.compose.material.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.rotate
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.input.TextFieldValue
import androidx.compose.ui.unit.dp
import com.miam.core.localisation.Localisation
import com.miam.kmm_miam_sdk.android.ressource.Image
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.kmm_miam_sdk.android.ui.components.common.Clickable

class PreferencesSearchFieldImp: PreferencesSearchField {

    @Composable
    override fun Content(param: PreferencesSearchFieldParameters) {

        var text by remember { mutableStateOf(TextFieldValue("")) }

        Row(Modifier.padding(vertical = 24.dp, horizontal = 16.dp), verticalAlignment = Alignment.CenterVertically) {
            BackButton(param.back)
            Row(
                Modifier
                    .fillMaxWidth()
                    .border(
                        border = BorderStroke(1.dp, Colors.grey),
                        shape = RoundedCornerShape(50)
                    ),
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.SpaceBetween
            ) {
                TextField(
                    value = text,
                    onValueChange = {
                        text = it
                        param.onChange(text.text)
                    },
                    colors = TextFieldDefaults.textFieldColors(
                        disabledTextColor = Color.Transparent,
                        backgroundColor = Color.White,
                        focusedIndicatorColor = Color.Transparent,
                        unfocusedIndicatorColor = Color.Transparent,
                        disabledIndicatorColor = Color.Transparent
                    ),
                    placeholder = {
                        Text(Localisation.Preferences.searchPlaceholder.localised)
                    }
                )
            }
        }
    }

    @Composable
    fun BackButton(back: () -> Unit) {
        Clickable(onClick = { back() }) {
            Image(
                painter = painterResource(Image.toggleCaret),
                contentDescription = null,
                Modifier
                    .rotate(180f)
                    .padding(vertical = 8.dp)
            )
        }
    }
}