package com.miam.sdk.components.preferences.search

import android.content.Context
import android.util.AttributeSet
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.AbstractComposeView
import com.miam.core.handler.LogHandler
import com.miam.core.model.Tag
import com.miam.core.viewModels.preferencesSearch.PreferencesSearchViewModel
import com.miam.kmm_miam_sdk.android.theme.Colors
import com.miam.sdk.components.baseComponent.ManagementResourceState
import com.miam.sdk.components.baseComponent.emptyPage.EmptyPageParameters
import com.miam.sdk.components.baseComponent.loader.LoaderParameters
import com.miam.sdk.components.preferences.search.field.PreferencesSearchFieldParameters
import com.miam.sdk.components.preferences.search.success.resultRow.PreferencesSearchResultRowParameters
import com.miam.sdk.di.TemplateDI

class PreferencesSearch @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): AbstractComposeView(context, attrs, defStyleAttr) {

    private var back: () -> Unit = {
        LogHandler.error("[Miam][Error] you must bind back function")
    }
    private var addTag: (tag: Tag) -> Unit = {
        LogHandler.error("[Miam][Error] you must bind addTag function")
    }

    fun bind(
        back: () -> Unit,
        addTag: (tag: Tag) -> Unit
    ) {
        this.back = back
        this.addTag = addTag
    }

    private val preferencesSearchVM = PreferencesSearchViewModel()

    @Composable
    override fun Content() {

        val state by preferencesSearchVM.uiState.collectAsState()

        Column(
            Modifier
                .fillMaxSize()
                .background(Colors.white)
        ) {
            TemplateDI.preferences.search.field.view.Content(
                param = PreferencesSearchFieldParameters(
                    back = back,
                    onChange = { preferencesSearchVM.search(it) }
                )
            )

            ManagementResourceState(
                resourceState = state.searchProposal,
                successView = { tags ->
                    requireNotNull(tags)
                    Column {
                        tags.forEach { tag ->
                            tag.attributes?.name?.let { name ->
                                TemplateDI.preferences.search.success.resultRow.view.Content(
                                    param = PreferencesSearchResultRowParameters(name) {
                                        preferencesSearchVM.resetState()
                                        addTag(tag)
                                    }
                                )
                            }
                        }
                    }
                },
                loadingView = {
                    TemplateDI.preferences.search.loading?.view?.Content(params = LoaderParameters)
                        ?: TemplateDI.defaultViews.loading.view.Content(params = LoaderParameters)
                },
                emptyView = {
                    TemplateDI.preferences.search.empty?.view?.Content(
                        params = EmptyPageParameters("")
                    ) ?: TemplateDI.defaultViews.empty.view.Content(
                        EmptyPageParameters("Aucun résulat")
                    )
                }
            )
        }
    }
}
