package com.miam.sdk.components.mealPlanner.meals.recipe.loading

import androidx.compose.animation.core.FastOutLinearInEasing
import androidx.compose.animation.core.animateFloat
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp

class MealPlannerRecipeLoadingImp: MealPlannerRecipeLoading {
    @Composable
    override fun Content(mealPlannerRecipeLoadingParameters: MealPlannerRecipeLoadingParameters) {

        val shimerColors = listOf(
            Color.LightGray.copy(alpha = 0.6F),
            Color.LightGray.copy(alpha = 0.2F),
            Color.LightGray.copy(alpha = 0.6F)
        )

        val transition = rememberInfiniteTransition()
        val translateAnimation = transition.animateFloat(
            initialValue = 0f,
            targetValue = 1000f,
            animationSpec = infiniteRepeatable(
                animation = tween(
                    durationMillis = 1000,
                    easing = FastOutLinearInEasing
                )
            )
        )

        val brush = Brush.linearGradient(
            colors = shimerColors,
            start = Offset.Zero,
            end = Offset(
                x = translateAnimation.value,
                y = translateAnimation.value
            )
        )

        when (mealPlannerRecipeLoadingParameters.displayComponent) {
            Component.PLANNER -> ShimmerMealPlannerRecipeCardRow(brush)
            Component.SEARCH_RESULT -> ShimmerMealPlannerRecipeCardColumn(brush)
        }

    }

    @Composable
    fun ShimmerMealPlannerRecipeCardRow(brush: Brush) {

        Row(
            modifier = Modifier
                .height(200.dp)
                .padding(vertical = 8.dp)
        ) {
            Column {
                Spacer(
                    modifier = Modifier
                        .fillMaxHeight()
                        .width(150.dp)
                        .clip(RoundedCornerShape(8.dp))
                        .background(brush = brush)
                )
            }
            Column {
                Spacer(
                    modifier = Modifier
                        .padding(vertical = 10.dp, horizontal = 20.dp)
                        .height(20.dp)
                        .width(300.dp)
                        .clip(RoundedCornerShape(100))
                        .background(brush = brush)
                )
                Spacer(
                    modifier = Modifier
                        .padding(vertical = 1.dp, horizontal = 40.dp)
                        .height(20.dp)
                        .width(300.dp)
                        .clip(RoundedCornerShape(100))
                        .background(brush = brush)
                )
                Row(
                    modifier = Modifier
                        .padding(vertical = 25.dp, horizontal = 30.dp)
                        .fillMaxWidth()
                ) {
                    Column(modifier = Modifier.padding(horizontal = 8.dp)) {
                        Spacer(
                            modifier = Modifier
                                .padding(vertical = 1.dp, horizontal = 20.dp)
                                .height(20.dp)
                                .width(20.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                        Spacer(
                            modifier = Modifier
                                .padding(vertical = 1.dp)
                                .height(20.dp)
                                .width(60.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                    }
                    Column(modifier = Modifier.padding(horizontal = 8.dp)) {
                        Spacer(
                            modifier = Modifier
                                .padding(vertical = 1.dp, horizontal = 20.dp)
                                .height(20.dp)
                                .width(20.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )

                        Spacer(
                            modifier = Modifier
                                .padding(vertical = 1.dp)
                                .height(20.dp)
                                .width(60.dp)
                                .clip(RoundedCornerShape(100))
                                .background(brush = brush)
                        )
                    }
                }
                Spacer(
                    modifier = Modifier
                        .padding(vertical = 1.dp, horizontal = 70.dp)
                        .height(20.dp)
                        .width(80.dp)
                        .clip(RoundedCornerShape(100))
                        .background(brush = brush)
                )
            }

        }

    }

    @Composable
    fun ShimmerMealPlannerRecipeCardColumn(brush: Brush) {
        Column(
            modifier = Modifier
                .height(344.dp)
                .width(196.dp), horizontalAlignment = Alignment.CenterHorizontally
        ) {
            Spacer(
                modifier = Modifier
                    .fillMaxWidth()
                    .height(152.dp)
                    .clip(RoundedCornerShape(8.dp))
                    .background(brush = brush)
            )
            Spacer(
                modifier = Modifier
                    .padding(vertical = 10.dp)
                    .height(20.dp)
                    .width(130.dp)
                    .clip(RoundedCornerShape(100))
                    .background(brush = brush)
            )
            Row(
                modifier = Modifier
                    .padding(vertical = 25.dp)
                    .fillMaxWidth()
                    .align(Alignment.CenterHorizontally),
                horizontalArrangement = Arrangement.Center
            ) {
                Column(modifier = Modifier.padding(horizontal = 10.dp)) {
                    Spacer(
                        modifier = Modifier
                            .padding(vertical = 1.dp, horizontal = 20.dp)
                            .height(20.dp)
                            .width(20.dp)
                            .clip(RoundedCornerShape(100))
                            .background(brush = brush)
                    )
                    Spacer(
                        modifier = Modifier
                            .padding(vertical = 1.dp)
                            .height(20.dp)
                            .width(60.dp)
                            .clip(RoundedCornerShape(100))
                            .background(brush = brush)
                    )
                }
                Column(modifier = Modifier.padding(horizontal = 10.dp)) {
                    Spacer(
                        modifier = Modifier
                            .padding(vertical = 1.dp, horizontal = 20.dp)
                            .height(20.dp)
                            .width(20.dp)
                            .clip(RoundedCornerShape(100))
                            .background(brush = brush)
                    )

                    Spacer(
                        modifier = Modifier
                            .padding(vertical = 1.dp)
                            .height(20.dp)
                            .width(60.dp)
                            .clip(RoundedCornerShape(100))
                            .background(brush = brush)
                    )
                }
            }
            Spacer(
                modifier = Modifier
                    .padding(vertical = 20.dp)
                    .height(20.dp)
                    .width(80.dp)
                    .clip(RoundedCornerShape(100))
                    .background(brush = brush)
            )
        }
    }
}

